/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.binding;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.binding.Binding;
import com.tibbo.aggregate.common.binding.EvaluationOptions;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.util.ThreadUtils;

public class BindingEventsHelper {
    public static final String E_BINDING_ERROR = "bindingError";
    public static final String E_BINDING_EXECUTION = "bindingExecution";
    public static final String EF_BINDING_CONTEXT = "context";
    public static final String EF_BINDING_TARGET = "target";
    public static final String EF_BINDING_EXPRESSION = "expression";
    public static final String EF_BINDING_ACTIVATOR = "activator";
    public static final String EF_BINDING_EXECUTION = "execution";
    public static final String EF_BINDING_CONDITION = "condition";
    public static final String EF_BINDING_VALUE = "value";
    public static final String EF_BINDING_CAUSE = "cause";
    public static final String EF_BINDING_ERROR = "error";
    public static final String EF_BINDING_ERROR_STACK = "stack";
    public static final TableFormat EFT_BINDING_EXECUTION = new TableFormat(1, 1);
    public static final TableFormat EFT_BINDING_EXECUTION_EXT;
    public static final TableFormat EFT_BINDING_ERROR;
    public static final TableFormat EFT_BINDING_ERROR_EXT;

    public static DataTable createBindingErrorEventData(Context con, Binding binding, int method, String activator, Exception error) {
        SimpleDataTable dt = new SimpleDataTable(con == null ? EFT_BINDING_ERROR : EFT_BINDING_ERROR_EXT);
        DataRecord record = dt.addRecord();
        if (con != null) {
            record.setValue(EF_BINDING_CONTEXT, (Object)con.getPath());
        }
        if (binding != null) {
            record.setValue(EF_BINDING_TARGET, (Object)binding.getTarget().toString());
            record.setValue(EF_BINDING_EXPRESSION, (Object)binding.getExpression().toString());
        }
        if (error != null) {
            record.setValue(EF_BINDING_ERROR, (Object)error.getMessage());
            DataTable stackTable = ThreadUtils.createStackTraceTable(error.getStackTrace());
            record.setValue(EF_BINDING_ERROR_STACK, (Object)stackTable);
        }
        record.setValue(EF_BINDING_ACTIVATOR, (Object)activator);
        record.setValue(EF_BINDING_EXECUTION, (Object)BindingEventsHelper.executionTypeDescription(method));
        return dt;
    }

    public static DataTable createBindingExecutionEventData(Context con, int method, Binding binding, EvaluationOptions options, Reference cause, Object result) {
        DataRecord data = new DataRecord(con == null ? EFT_BINDING_EXECUTION : EFT_BINDING_EXECUTION_EXT);
        if (con != null) {
            data.setValue(EF_BINDING_CONTEXT, (Object)con.getPath());
        }
        data.setValue(EF_BINDING_TARGET, (Object)binding.getTarget().toString());
        data.setValue(EF_BINDING_EXPRESSION, (Object)binding.getExpression().toString());
        if (options.getActivator() != null) {
            data.setValue(EF_BINDING_ACTIVATOR, (Object)options.getActivator().toString());
        }
        if (options.getCondition() != null) {
            data.setValue(EF_BINDING_CONDITION, (Object)options.getCondition().toString());
        }
        if (result != null) {
            data.setValue(EF_BINDING_VALUE, (Object)result.toString());
        }
        if (cause != null) {
            data.setValue(EF_BINDING_CAUSE, (Object)cause.toString());
        }
        data.setValue(EF_BINDING_EXECUTION, (Object)BindingEventsHelper.executionTypeDescription(method));
        return data.wrap();
    }

    private static String executionTypeDescription(int method) {
        String exec = method == 1 ? Cres.get().getString("wOnStartup") : (method == 2 ? Cres.get().getString("wOnEvent") : Cres.get().getString("wPeriodically"));
        return exec;
    }

    static {
        EFT_BINDING_EXECUTION.addField(FieldFormat.create("<target><S><D=" + Cres.get().getString(EF_BINDING_TARGET) + "><F=N><E=" + EF_BINDING_CONTEXT + ">"));
        EFT_BINDING_EXECUTION.addField(FieldFormat.create("<expression><S><F=N><D=" + Cres.get().getString(EF_BINDING_EXPRESSION) + ">"));
        EFT_BINDING_EXECUTION.addField(FieldFormat.create("<value><S><F=N><D=" + Cres.get().getString(EF_BINDING_VALUE) + ">"));
        EFT_BINDING_EXECUTION.addField(FieldFormat.create("<activator><S><F=N><D=" + Cres.get().getString("wActivatorDescr") + ">"));
        EFT_BINDING_EXECUTION.addField(FieldFormat.create("<condition><S><F=N><D=" + Cres.get().getString(EF_BINDING_CONDITION) + ">"));
        EFT_BINDING_EXECUTION.addField(FieldFormat.create("<execution><S><D=" + Cres.get().getString("wExecution") + ">"));
        EFT_BINDING_EXECUTION.addField(FieldFormat.create("<cause><S><F=N><D=" + Cres.get().getString(EF_BINDING_CAUSE) + ">"));
        EFT_BINDING_EXECUTION_EXT = EFT_BINDING_EXECUTION.clone();
        EFT_BINDING_EXECUTION_EXT.addField(FieldFormat.create("<context><S><D=" + Cres.get().getString(EF_BINDING_CONTEXT) + "><F=N><E=" + EF_BINDING_CONTEXT + ">"), 0);
        EFT_BINDING_ERROR = EFT_BINDING_EXECUTION.clone();
        EFT_BINDING_ERROR.removeField(EF_BINDING_VALUE);
        EFT_BINDING_ERROR.removeField(EF_BINDING_CONDITION);
        EFT_BINDING_ERROR.addField(FieldFormat.create("<error><S><D=" + Cres.get().getString(EF_BINDING_ERROR) + "><E=" + "textarea" + ">"));
        EFT_BINDING_ERROR.addField(FieldFormat.create("<stack><T><D=" + Cres.get().getString(EF_BINDING_ERROR_STACK) + ">"));
        EFT_BINDING_ERROR_EXT = EFT_BINDING_ERROR.clone();
        EFT_BINDING_ERROR_EXT.addField(FieldFormat.create("<context><S><D=" + Cres.get().getString(EF_BINDING_CONTEXT) + "><F=N>"), 0);
    }
}

