/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.binding;

import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.expression.ExpressionUtils;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.util.PublicCloneable;

public class Binding
implements Cloneable,
PublicCloneable {
    private Long id;
    private int row;
    private Reference target;
    private Expression expression;
    private String queue;

    public Binding(Reference target, Expression expression) {
        this.target = target;
        this.expression = expression;
    }

    public Binding(String reference, String expression) {
        this.target = new Reference(reference);
        this.expression = new Expression(expression);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Reference getTarget() {
        return this.target;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    int getRow() {
        return this.row;
    }

    void setRow(int row) {
        this.row = row;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Binding other = (Binding)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    @Override
    public Binding clone() {
        try {
            Binding clone = (Binding)super.clone();
            clone.target = this.target.clone();
            clone.expression = this.expression != null ? this.expression.clone() : null;
            clone.id = this.id == null ? null : Long.valueOf(ExpressionUtils.generateBindingId());
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public String toString() {
        return this.target + " = " + this.expression;
    }
}

