/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.binding;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.binding.Binding;
import com.tibbo.aggregate.common.binding.BindingException;
import com.tibbo.aggregate.common.binding.BindingProvider;
import com.tibbo.aggregate.common.binding.EvaluationOptions;
import com.tibbo.aggregate.common.device.DisconnectionException;
import com.tibbo.aggregate.common.expression.ExpressionUtils;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.util.ErrorCollector;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public abstract class AbstractBindingProvider<T>
implements BindingProvider<T> {
    private ErrorCollector errorCollector;

    public AbstractBindingProvider() {
    }

    public AbstractBindingProvider(ErrorCollector errorCollector) {
        this.errorCollector = errorCollector;
    }

    @Override
    public void processExecution(int method, Binding binding, EvaluationOptions options, Reference cause, Object result) {
        if (Log.BINDINGS.isDebugEnabled()) {
            Log.BINDINGS.debug((Object)this.buildExecutionMessage(method, binding, options, cause, result));
        }
    }

    protected String buildExecutionMessage(int method, Binding binding, EvaluationOptions options, Reference cause, Object result) {
        String res = "";
        switch (method) {
            case 1: {
                res = "Evaluating '" + binding.getExpression() + "' on startup and writing result (" + result + ") into '" + binding.getTarget() + "'";
                break;
            }
            case 2: {
                res = "Change of '" + cause + "' caused evaluation of '" + binding.getExpression() + "' and writing result (" + result + ") into '" + binding.getTarget() + "'";
                break;
            }
            case 4: {
                res = "Periodical evaluation of '" + binding.getExpression() + "' caused writing result (" + result + ") into '" + binding.getTarget() + "'";
            }
        }
        return res;
    }

    protected String buildErrorMessage(Binding binding, int method, Reference cause, Exception error) {
        return MessageFormat.format(Cres.get().getString("binBindingError"), binding) + error.getMessage();
    }

    @Override
    public void processError(Binding binding, int method, Reference cause, Exception error) {
        String message = this.buildErrorMessage(binding, method, cause, error);
        if (this.errorCollector != null) {
            this.errorCollector.addError(new BindingException(message, error));
        } else {
            boolean disconnected;
            boolean bl = disconnected = ExceptionUtils.indexOfType((Throwable)error, DisconnectionException.class) != -1;
            if (disconnected) {
                if (Log.BINDINGS.isDebugEnabled()) {
                    Log.BINDINGS.log((Priority)Level.DEBUG, (Object)message, (Throwable)error);
                }
            } else {
                Log.BINDINGS.log((Priority)Level.ERROR, (Object)message);
                if (Log.BINDINGS.isDebugEnabled()) {
                    Log.BINDINGS.log((Priority)Level.DEBUG, (Object)error);
                }
            }
        }
    }

    @Override
    public List<Reference> getReferences(Binding binding) throws BindingException {
        try {
            return ExpressionUtils.findReferences(binding.getExpression());
        }
        catch (SyntaxErrorException ex) {
            throw new BindingException(ex.getMessage(), ex);
        }
    }
}

