/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.agent;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.agent.HistoricalValue;
import com.tibbo.aggregate.common.context.AbstractContext;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.EventDefinition;
import com.tibbo.aggregate.common.context.FunctionDefinition;
import com.tibbo.aggregate.common.context.FunctionImplementation;
import com.tibbo.aggregate.common.context.RequestController;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.context.VariableGetter;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableConversion;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.datatable.encoding.FormatCache;
import com.tibbo.aggregate.common.datatable.encoding.KnownFormatCollector;
import com.tibbo.aggregate.common.device.DeviceAssetDefinition;
import com.tibbo.aggregate.common.protocol.RemoteServer;
import com.tibbo.aggregate.common.server.CommonServerFormats;
import com.tibbo.aggregate.common.util.Md5Utils;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class AgentContext
extends AbstractContext {
    public static final String V_DATE = "date";
    public static final String F_LOGIN = "login";
    public static final String F_EXT_LOGIN = "extLogin";
    public static final String F_REGISTER = "register";
    public static final String F_SYNCHRONIZED = "synchronized";
    public static final String F_CONFIRM_EVENT = "confirmEvent";
    public static final String F_ACKNOWLEDGE_EVENT = "acknowledgeEvent";
    public static final String F_GET_HISTORY = "getHistory";
    public static final String F_SEND_BUFFERED_EVENTS = "sendBufferedEvents";
    public static final String E_EVENT_CONFIRMED = "eventConfirmed";
    public static final String FIF_LOGIN_CHALLENGE = "challenge";
    public static final String FIF_CONFIRM_EVENT_ID = "id";
    public static final String FIF_ACKNOWLEDGE_EVENT_ID = "id";
    public static final String FIF_ACKNOWLEDGE_EVENT_DATE = "date";
    public static final String FIF_ACKNOWLEDGE_EVENT_AUTHOR = "author";
    public static final String FIF_ACKNOWLEDGE_EVENT_ACKNOWLEDGEMENT = "acknowledgement";
    public static final String FIF_ACKNOWLEDGE_EVENT_EVENT_DATA = "eventData";
    public static final String FOF_LOGIN_OWNER = "owner";
    public static final String FOF_LOGIN_NAME = "name";
    public static final String FOF_LOGIN_RESPONSE = "response";
    public static final String FOF_PASSWORD = "password";
    public static final String FOF_COMMAND_TIMEOUT = "commandTimeout";
    public static final String FOF_GET_HISTORY_VARIABLE = "variable";
    public static final String FOF_GET_HISTORY_TIMESTAMP = "timestamp";
    public static final String FOF_GET_HISTORY_VALUE = "value";
    public static final String FOF_BUFFERED_EVENTS_SENT = "bufferedEventsSent";
    public static final String EF_EVENT_CONFIRMED_ID = "id";
    public static final TableFormat FIFT_LOGIN = new TableFormat(1, 1, "<challenge><S>");
    public static final TableFormat FOFT_LOGIN = new TableFormat(1, 1);
    public static final TableFormat FOFT_EXT_LOGIN;
    public static final TableFormat FOFT_REGISTER;
    public static final TableFormat FOFT_GET_HISTORY;
    public static final TableFormat FOFT_SEND_BUFFERED_EVENTS;
    public static final TableFormat FIFT_CONFIRM_EVENT;
    public static final TableFormat FIFT_ACKNOWLEDGE_EVENT;
    public static final TableFormat EFT_EVENT_CONFIRMED;
    private final RemoteServer server;
    private final String name;
    private final boolean eventConfirmation;
    private boolean isSynchronized;
    private List<DeviceAssetDefinition> assets = new LinkedList<DeviceAssetDefinition>();
    private FormatCache formatCache;
    private KnownFormatCollector knownFormatCollector;
    VariableGetter assetReader = new VariableGetter(){

        @Override
        public DataTable get(Context con, VariableDefinition def, CallerController caller, RequestController request) throws ContextException {
            return DataTableConversion.beansToTable(AgentContext.this.assets, DeviceAssetDefinition.FORMAT);
        }
    };
    FunctionImplementation loginImpl = new FunctionImplementation(){

        @Override
        public DataTable execute(Context con, FunctionDefinition def, CallerController caller, RequestController request, DataTable parameters) throws ContextException {
            String challenge = parameters.rec().getString(AgentContext.FIF_LOGIN_CHALLENGE);
            String response = Md5Utils.hexHash(challenge + AgentContext.this.server.getPassword());
            return new DataRecord(FOFT_LOGIN).addString(AgentContext.this.server.getUsername()).addString(AgentContext.this.name).addString(response).wrap();
        }
    };
    FunctionImplementation registerImpl = new FunctionImplementation(){

        @Override
        public DataTable execute(Context con, FunctionDefinition def, CallerController caller, RequestController request, DataTable parameters) throws ContextException {
            return new DataRecord(FOFT_REGISTER).setValue(AgentContext.FOF_PASSWORD, (Object)AgentContext.this.server.getPassword()).setValue(AgentContext.FOF_COMMAND_TIMEOUT, (Object)AgentContext.this.server.getCommandTimeout()).wrap();
        }
    };
    FunctionImplementation externalLoginImpl = new FunctionImplementation(){

        @Override
        public DataTable execute(Context con, FunctionDefinition def, CallerController caller, RequestController request, DataTable parameters) throws ContextException {
            return new DataRecord(FOFT_EXT_LOGIN).setValue(AgentContext.FOF_PASSWORD, (Object)AgentContext.this.server.getPassword()).wrap();
        }
    };
    FunctionImplementation synchronizedImpl = new FunctionImplementation(){

        @Override
        public DataTable execute(Context con, FunctionDefinition def, CallerController caller, RequestController request, DataTable parameters) throws ContextException {
            AgentContext.this.setSynchronized(true);
            return null;
        }
    };
    FunctionImplementation confirmEventImpl = new FunctionImplementation(){

        @Override
        public DataTable execute(Context con, FunctionDefinition def, CallerController caller, RequestController request, DataTable parameters) throws ContextException {
            AgentContext.this.confirmEvent(parameters.rec().getLong("id"));
            return null;
        }
    };
    FunctionImplementation acknowledgeEventImpl = new FunctionImplementation(){

        @Override
        public DataTable execute(Context con, FunctionDefinition def, CallerController caller, RequestController request, DataTable parameters) throws ContextException {
            AgentContext.this.acknowledgeEvent(parameters.rec().getLong("id"), parameters.rec().getDate("date"), parameters.rec().getString(AgentContext.FIF_ACKNOWLEDGE_EVENT_AUTHOR), parameters.rec().getString(AgentContext.FIF_ACKNOWLEDGE_EVENT_ACKNOWLEDGEMENT), parameters.rec().getDataTable(AgentContext.FIF_ACKNOWLEDGE_EVENT_EVENT_DATA));
            return null;
        }
    };
    FunctionImplementation getHistoryImpl = new FunctionImplementation(){

        @Override
        public DataTable execute(Context con, FunctionDefinition def, CallerController caller, RequestController request, DataTable parameters) throws ContextException {
            SimpleDataTable res = new SimpleDataTable(def.getOutputFormat());
            for (HistoricalValue hv : AgentContext.this.getHistory()) {
                DataRecord rec = res.addRecord();
                rec.addString(hv.getVariable());
                rec.addDate(hv.getTimestamp());
                rec.addDataTable(hv.getValue());
            }
            return res;
        }
    };
    FunctionImplementation getFormatImpl = new FunctionImplementation(){

        @Override
        public DataTable execute(Context con, FunctionDefinition def, CallerController caller, RequestController request, DataTable parameters) throws ContextException {
            int id = parameters.rec().getInt("id");
            if (AgentContext.this.knownFormatCollector != null && AgentContext.this.knownFormatCollector.isKnown(id)) {
                TableFormat format;
                TableFormat tableFormat = format = AgentContext.this.formatCache != null ? AgentContext.this.formatCache.get(id) : null;
                if (format == null) {
                    throw new ContextException("Format with requested ID does not exist: " + id);
                }
                return new SimpleDataTable(CommonServerFormats.FOFT_GET_FORMAT, format.encode(new ClassicEncodingSettings(false)));
            }
            throw new ContextException("Format with requested ID does not exist or is not available: " + id);
        }
    };
    FunctionImplementation sendBufferedEventsImpl = new FunctionImplementation(){

        @Override
        public DataTable execute(Context con, FunctionDefinition def, CallerController caller, RequestController request, DataTable parameters) throws ContextException {
            DataRecord rec = new DataRecord(FOFT_SEND_BUFFERED_EVENTS);
            rec.setValue(AgentContext.FOF_BUFFERED_EVENTS_SENT, (Object)AgentContext.this.sendBufferedEvents());
            return rec.wrap();
        }
    };

    public AgentContext(RemoteServer server, String name, boolean eventConfirmation) {
        super("");
        this.server = server;
        this.name = name;
        this.eventConfirmation = eventConfirmation;
    }

    @Override
    public void setupMyself() throws ContextException {
        super.setupMyself();
        VariableDefinition vd = new VariableDefinition("assets", DeviceAssetDefinition.FORMAT, true, false);
        vd.setGetter(this.assetReader);
        this.addVariableDefinition(vd);
        FunctionDefinition fd = new FunctionDefinition(F_LOGIN, FIFT_LOGIN, FOFT_LOGIN, Cres.get().getString(F_LOGIN));
        fd.setImplementation(this.loginImpl);
        this.addFunctionDefinition(fd);
        fd = new FunctionDefinition(F_EXT_LOGIN, TableFormat.EMPTY_FORMAT, FOFT_EXT_LOGIN, Cres.get().getString(F_EXT_LOGIN));
        fd.setImplementation(this.externalLoginImpl);
        this.addFunctionDefinition(fd);
        fd = new FunctionDefinition(F_REGISTER, TableFormat.EMPTY_FORMAT, FOFT_REGISTER, Cres.get().getString(F_REGISTER));
        fd.setImplementation(this.registerImpl);
        this.addFunctionDefinition(fd);
        fd = new FunctionDefinition(F_SYNCHRONIZED, TableFormat.EMPTY_FORMAT, TableFormat.EMPTY_FORMAT);
        fd.setImplementation(this.synchronizedImpl);
        this.addFunctionDefinition(fd);
        fd = new FunctionDefinition(F_CONFIRM_EVENT, FIFT_CONFIRM_EVENT, TableFormat.EMPTY_FORMAT);
        fd.setImplementation(this.confirmEventImpl);
        this.addFunctionDefinition(fd);
        fd = new FunctionDefinition(F_ACKNOWLEDGE_EVENT, FIFT_ACKNOWLEDGE_EVENT, TableFormat.EMPTY_FORMAT);
        fd.setImplementation(this.acknowledgeEventImpl);
        this.addFunctionDefinition(fd);
        fd = new FunctionDefinition(F_GET_HISTORY, TableFormat.EMPTY_FORMAT, FOFT_GET_HISTORY);
        fd.setImplementation(this.getHistoryImpl);
        this.addFunctionDefinition(fd);
        fd = new FunctionDefinition(F_SEND_BUFFERED_EVENTS, TableFormat.EMPTY_FORMAT, FOFT_SEND_BUFFERED_EVENTS);
        fd.setImplementation(this.sendBufferedEventsImpl);
        this.addFunctionDefinition(fd);
        fd = new FunctionDefinition("getFormat", CommonServerFormats.FIFT_GET_FORMAT, null);
        fd.setImplementation(this.getFormatImpl);
        fd.setConcurrent(true);
        this.addFunctionDefinition(fd);
        if (this.eventConfirmation) {
            EventDefinition ed = new EventDefinition(E_EVENT_CONFIRMED, EFT_EVENT_CONFIRMED);
            this.addEventDefinition(ed);
        }
    }

    public void addAsset(DeviceAssetDefinition asset) {
        this.assets.add(asset);
    }

    public List<DeviceAssetDefinition> getAssets() {
        return this.assets;
    }

    public void setAssets(List<DeviceAssetDefinition> assets) {
        this.assets = assets;
    }

    protected void confirmEvent(Long id) {
        if (this.getEventDefinition(E_EVENT_CONFIRMED) != null) {
            this.fireEvent(E_EVENT_CONFIRMED, id);
        }
    }

    protected void acknowledgeEvent(Long id, Date date, String author, String acknowledgement, DataTable data) {
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public void setSynchronized(boolean isSynchronized) {
        this.isSynchronized = isSynchronized;
    }

    public RemoteServer getServer() {
        return this.server;
    }

    public void setFormatCache(FormatCache formatCache) {
        this.formatCache = formatCache;
    }

    public void setKnownFormatCollector(KnownFormatCollector knownFormatCollector) {
        this.knownFormatCollector = knownFormatCollector;
    }

    protected List<HistoricalValue> getHistory() {
        return Collections.emptyList();
    }

    protected int sendBufferedEvents() {
        return 0;
    }

    static {
        FOFT_LOGIN.addField("<owner><S>");
        FOFT_LOGIN.addField("<name><S>");
        FOFT_LOGIN.addField("<response><S>");
        FOFT_EXT_LOGIN = new TableFormat(1, 1);
        FOFT_EXT_LOGIN.addField("<password><S>");
        FOFT_REGISTER = new TableFormat(1, 1);
        FOFT_REGISTER.addField("<password><S>");
        FOFT_REGISTER.addField("<commandTimeout><L>");
        FOFT_GET_HISTORY = new TableFormat();
        FOFT_GET_HISTORY.addField("<variable><S>");
        FOFT_GET_HISTORY.addField("<timestamp><D>");
        FOFT_GET_HISTORY.addField("<value><T>");
        FOFT_SEND_BUFFERED_EVENTS = new TableFormat(1, 1, "<bufferedEventsSent><I>");
        FIFT_CONFIRM_EVENT = new TableFormat(1, 1, "<id><L>");
        FIFT_ACKNOWLEDGE_EVENT = new TableFormat(1, 1);
        FIFT_ACKNOWLEDGE_EVENT.addField("<id><L><F=N>");
        FIFT_ACKNOWLEDGE_EVENT.addField("<date><D>");
        FIFT_ACKNOWLEDGE_EVENT.addField("<author><S><F=N>");
        FIFT_ACKNOWLEDGE_EVENT.addField("<acknowledgement><S>");
        FIFT_ACKNOWLEDGE_EVENT.addField("<eventData><T>");
        EFT_EVENT_CONFIRMED = new TableFormat(1, 1, "<id><L>");
    }
}

