/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.agent;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.agent.AgentContext;
import com.tibbo.aggregate.common.agent.AgentImplementationController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.DefaultContextManager;
import com.tibbo.aggregate.common.context.DefaultContextVisitor;
import com.tibbo.aggregate.common.context.EventDefinition;
import com.tibbo.aggregate.common.datatable.DataTableRegistry;
import com.tibbo.aggregate.common.datatable.encoding.FormatCache;
import com.tibbo.aggregate.common.datatable.encoding.LocalFormatCache;
import com.tibbo.aggregate.common.device.DisconnectionException;
import com.tibbo.aggregate.common.device.RemoteDeviceErrorException;
import com.tibbo.aggregate.common.protocol.RemoteServer;
import com.tibbo.aggregate.common.protocol.SslHelper;
import com.tibbo.aggregate.common.util.BlockingChannel;
import com.tibbo.aggregate.common.util.NamedThreadFactory;
import com.tibbo.aggregate.common.util.SocketBlockingChannel;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import java.io.IOException;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class Agent {
    public static final int DEFAULT_PORT = 6480;
    public static final int DEFAULT_SECURE_PORT = 6481;
    private final RemoteServer server;
    private final AgentContext context;
    private final ContextManager<Context> contextManager;
    private boolean useSecureConnection = false;
    private boolean useDataCompression = false;
    private AgentImplementationController controller;
    private ThreadPoolExecutor commandExecutionService;
    private int bufferSize;
    private int pendingEventsQueueCapacity = Integer.MAX_VALUE;
    private int maxCommandExecutors = Integer.MAX_VALUE;

    public Agent(RemoteServer server, String name, boolean eventConfirmation) {
        this.server = server;
        this.context = new AgentContext(server, name, eventConfirmation);
        this.contextManager = new AgentContextManager(this.context, false);
    }

    public Agent(AgentContext context) {
        this(context, false, false, 0);
    }

    public Agent(AgentContext context, boolean useSecureConnection, boolean useDataCompression, int bufferSize) {
        this.server = context.getServer();
        this.context = context;
        this.contextManager = new AgentContextManager(context, false);
        this.useSecureConnection = useSecureConnection;
        this.useDataCompression = useDataCompression;
        this.bufferSize = bufferSize;
    }

    public Agent(AgentContext context, boolean useSecureConnection, boolean useDataCompression, int bufferSize, int pendingEventsQueueCapacity, int maxCommandExecutors) {
        this(context, useSecureConnection, useDataCompression, bufferSize);
        this.pendingEventsQueueCapacity = pendingEventsQueueCapacity;
        this.maxCommandExecutors = maxCommandExecutors;
    }

    public void connect() throws RemoteDeviceErrorException {
        try {
            this.context.setSynchronized(false);
            Log.PROTOCOL.debug((Object)("Connecting to remote server (" + this.server + ")"));
            BlockingChannel dataChannel = this.constructChannel();
            Log.PROTOCOL.debug((Object)"Connection with remote server established");
            this.contextManager.start();
            LocalFormatCache formatCache = new LocalFormatCache(this.server.getInfo());
            this.context.setFormatCache(formatCache);
            DataTableRegistry dataTableRegistry = new DataTableRegistry();
            this.commandExecutionService = new ThreadPoolExecutor(this.maxCommandExecutors, this.maxCommandExecutors, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("Agent/" + this.server));
            this.commandExecutionService.allowCoreThreadTimeOut(true);
            this.controller = new AgentImplementationController(dataChannel, (ContextManager)this.contextManager, (ExecutorService)this.commandExecutionService, (FormatCache)formatCache, dataTableRegistry, (Integer)this.pendingEventsQueueCapacity);
            this.context.setKnownFormatCollector(this.controller.getKnownFormatCollector());
            this.contextManager.getRoot().accept(new DefaultContextVisitor(){

                @Override
                public void visit(Context context) {
                    List<EventDefinition> eventDefinitions = context.getEventDefinitions();
                    for (EventDefinition ed : eventDefinitions) {
                        if (ed.getGroup() == null) continue;
                        context.addEventListener(ed.getName(), Agent.this.controller.getDefaultEventListener(), true);
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new RemoteDeviceErrorException(MessageFormat.format(Cres.get().getString("devErrConnecting"), this.server.getDescription() + " (" + this.server.getInfo() + ")") + ex.getMessage(), ex);
        }
    }

    protected BlockingChannel constructChannel() throws IOException {
        if (this.useSecureConnection) {
            SSLSocketFactory sslFactory = SslHelper.getTrustedSocketFactory();
            SSLSocket socket = (SSLSocket)sslFactory.createSocket(this.server.getAddress(), this.server.getPort());
            socket.setEnabledCipherSuites(socket.getSupportedCipherSuites());
            socket.setSoTimeout((int)this.server.getConnectionTimeout());
            socket.startHandshake();
            return new SocketBlockingChannel(socket, this.useDataCompression, this.bufferSize);
        }
        Socket socket = SocketFactory.getDefault().createSocket(this.server.getAddress(), this.server.getPort());
        socket.setSoTimeout((int)this.server.getConnectionTimeout());
        return new SocketBlockingChannel(socket, this.useDataCompression, this.bufferSize);
    }

    public void disconnect() {
        if (this.controller != null) {
            this.controller.shutdown();
        }
        if (this.contextManager != null) {
            this.contextManager.stop();
        }
        this.context.setSynchronized(false);
        if (this.commandExecutionService != null) {
            this.commandExecutionService.shutdown();
        }
    }

    public void run() throws DisconnectionException, SyntaxErrorException, IOException {
        this.controller.runImpl();
    }

    public long getStartMessageCount() {
        return this.controller.getStartMessageCount();
    }

    public Long getLastDataTimestamp() {
        return this.controller.getLastDataTimestamp();
    }

    public RemoteServer getServer() {
        return this.server;
    }

    public AgentContext getContext() {
        return this.context;
    }

    public boolean isConnected() {
        return this.controller != null && this.controller.isConnected();
    }

    public int getPendingEventsCount() {
        if (this.controller == null) {
            return 0;
        }
        return this.controller.getPendingEventsCount();
    }

    private class AgentContextManager
    extends DefaultContextManager<Context> {
        public AgentContextManager(Context rootContext, boolean async) {
            super(rootContext, async);
        }

        @Override
        public void eventAdded(Context con, EventDefinition ed) {
            super.eventAdded(con, ed);
            if (ed.getGroup() != null && Agent.this.controller != null) {
                con.addEventListener(ed.getName(), Agent.this.controller.getDefaultEventListener(), true);
            }
        }
    }
}

