/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.action.command;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.action.GenericActionCommand;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.util.DashboardProperties;
import com.tibbo.aggregate.common.util.DashboardsHierarchyInfo;
import com.tibbo.aggregate.common.util.WindowLocation;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class ShowSystemTree
extends GenericActionCommand {
    public static final String CF_ROOT = "root";
    public static final String CF_ROOTS = "roots";
    public static final String CF_LOCATION = "location";
    public static final String CF_DASHBOARD = "dashboard";
    public static final String CF_KEY = "key";
    public static final String CF_RELATED_ACTIONS = "relatedActions";
    public static final String CF_CONTEXT_MENU = "contextMenu";
    public static final String CF_SHOW_TOOLBAR = "showToolbar";
    public static final String CF_NODE_CLICK_EXPRESSION = "nodeClickExpression";
    public static final String CF_NODE_FILTER_EXPRESSION = "nodeFilterExpression";
    public static final String CF_DASHBOARDS_HIERARCHY_INFO = "dashboardsHierarchyInfo";
    public static final String CF_ROOTS_ROOT = "root";
    public static final TableFormat CFT_SHOW_SYSTEM_TREE_ROOTS = FieldFormat.create("<root><S>").wrap();
    public static final TableFormat CFT_SHOW_SYSTEM_TREE = new TableFormat(1, 1);
    private String root;
    private List<String> roots;
    private boolean relatedActions = true;
    private boolean contextMenu = true;
    private boolean showToolbar = true;
    private WindowLocation location;
    private DashboardProperties dashboard;
    private String key;
    private DashboardsHierarchyInfo dhInfo;
    private String nodeClickExpression;
    private String nodeFilterExpression;

    public ShowSystemTree() {
        super("showSystemTree", CFT_SHOW_SYSTEM_TREE, null);
    }

    public ShowSystemTree(String title, Context root) {
        super("showSystemTree", title);
        this.root = root.getPath();
    }

    public ShowSystemTree(String title, String ... roots) {
        super("showSystemTree", title);
        this.roots = Arrays.asList(roots);
    }

    public ShowSystemTree(String title, DataTable parameters) {
        super("showSystemTree", title);
        this.root = parameters.rec().getString("root");
        if (parameters.getFormat().hasField(CF_ROOTS)) {
            this.roots = new LinkedList<String>();
            for (DataRecord rec : parameters.rec().getDataTable(CF_ROOTS)) {
                this.roots.add(rec.getString("root"));
            }
        }
        this.relatedActions = parameters.rec().getBoolean(CF_RELATED_ACTIONS);
        this.contextMenu = parameters.rec().getBoolean(CF_CONTEXT_MENU);
        this.showToolbar = parameters.rec().getBoolean(CF_SHOW_TOOLBAR);
        if (parameters.getFormat().hasField(CF_LOCATION)) {
            DataTable loc = parameters.rec().getDataTable(CF_LOCATION);
            WindowLocation windowLocation = this.location = loc != null ? new WindowLocation(loc.rec()) : null;
        }
        if (parameters.getFormat().hasField(CF_DASHBOARD)) {
            DataTable db = parameters.rec().getDataTable(CF_DASHBOARD);
            DashboardProperties dashboardProperties = this.dashboard = db != null ? new DashboardProperties(db.rec()) : null;
        }
        if (parameters.getFormat().hasField(CF_KEY)) {
            this.key = parameters.rec().getString(CF_KEY);
        }
        if (parameters.getFormat().hasField(CF_DASHBOARDS_HIERARCHY_INFO)) {
            DataTable dh = parameters.rec().getDataTable(CF_DASHBOARDS_HIERARCHY_INFO);
            this.dhInfo = dh != null ? new DashboardsHierarchyInfo(dh.rec()) : null;
        }
    }

    @Override
    protected DataTable constructParameters() {
        DataRecord res = new DataRecord(CFT_SHOW_SYSTEM_TREE);
        res.addString(this.root);
        SimpleDataTable t = new SimpleDataTable(CFT_SHOW_SYSTEM_TREE_ROOTS);
        if (this.roots != null) {
            for (String each : this.roots) {
                t.addRecord(each);
            }
        }
        res.addDataTable(t);
        res.addBoolean(this.relatedActions);
        res.addBoolean(this.contextMenu);
        res.addBoolean(this.showToolbar);
        res.addDataTable(this.location != null ? this.location.toDataTable() : null);
        res.addDataTable(this.dashboard != null ? this.dashboard.toDataTable() : null);
        res.addString(this.key);
        res.addDataTable(this.dhInfo != null ? this.dhInfo.toDataTable() : null);
        res.setValue(CF_NODE_CLICK_EXPRESSION, (Object)this.nodeClickExpression);
        res.setValue(CF_NODE_FILTER_EXPRESSION, (Object)this.nodeFilterExpression);
        res.addDataTable(this.getComponentLocation() != null ? this.getComponentLocation().toDataTable() : null);
        return res.wrap();
    }

    public boolean isRelatedActions() {
        return this.relatedActions;
    }

    public void setRelatedActions(boolean relatedActions) {
        this.relatedActions = relatedActions;
    }

    public boolean isContextMenu() {
        return this.contextMenu;
    }

    public void setContextMenu(boolean contextMenu) {
        this.contextMenu = contextMenu;
    }

    public boolean isShowToolbar() {
        return this.showToolbar;
    }

    public void setShowToolbar(boolean showToolbar) {
        this.showToolbar = showToolbar;
    }

    public WindowLocation getLocation() {
        return this.location;
    }

    public void setLocation(WindowLocation location) {
        this.location = location;
    }

    public DashboardProperties getDashboard() {
        return this.dashboard;
    }

    public void setDashboard(DashboardProperties dashboard) {
        this.dashboard = dashboard;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getNodeClickExpression() {
        return this.nodeClickExpression;
    }

    public void setNodeClickExpression(String nodeClickExpression) {
        this.nodeClickExpression = nodeClickExpression;
    }

    public String getNodeFilterExpression() {
        return this.nodeFilterExpression;
    }

    public void setNodeFilterExpression(String nodeFilterExpression) {
        this.nodeFilterExpression = nodeFilterExpression;
    }

    public DashboardsHierarchyInfo getDashboardsHierarchyInfo() {
        return this.dhInfo;
    }

    public void setDashboardsHierarchyInfo(DashboardsHierarchyInfo dhInfo) {
        this.dhInfo = dhInfo;
    }

    static {
        CFT_SHOW_SYSTEM_TREE.addField("<root><S><F=N><D=" + Cres.get().getString("root") + "><E=" + "context" + ">");
        FieldFormat ff = FieldFormat.create("<roots><T>");
        ff.setDefault(new SimpleDataTable(CFT_SHOW_SYSTEM_TREE_ROOTS, true));
        CFT_SHOW_SYSTEM_TREE.addField(ff);
        ff = FieldFormat.create("<relatedActions><B><A=1><D=" + Cres.get().getString(CF_RELATED_ACTIONS) + ">");
        CFT_SHOW_SYSTEM_TREE.addField(ff);
        ff = FieldFormat.create("<contextMenu><B><A=1><D=" + Cres.get().getString(CF_CONTEXT_MENU) + ">");
        CFT_SHOW_SYSTEM_TREE.addField(ff);
        ff = FieldFormat.create("<showToolbar><B><A=1><D=" + Cres.get().getString("toolbar") + ">");
        CFT_SHOW_SYSTEM_TREE.addField(ff);
        ff = FieldFormat.create("<location><T><F=NH>");
        ff.setDefault(new WindowLocation().toDataTable());
        CFT_SHOW_SYSTEM_TREE.addField(ff);
        ff = FieldFormat.create("<dashboard><T><F=NH>");
        ff.setDefault(new DashboardProperties().toDataTable());
        CFT_SHOW_SYSTEM_TREE.addField(ff);
        CFT_SHOW_SYSTEM_TREE.addField("<key><S><F=NH><D=" + Cres.get().getString(CF_KEY) + ">");
        ff = FieldFormat.create("<dashboardsHierarchyInfo><T><F=NH>");
        ff.setDefault(new DashboardsHierarchyInfo().toDataTable());
        CFT_SHOW_SYSTEM_TREE.addField(ff);
        CFT_SHOW_SYSTEM_TREE.addField(FieldFormat.create(CF_NODE_CLICK_EXPRESSION, 'S', Cres.get().getString(CF_NODE_CLICK_EXPRESSION)).setNullable(true).setDefault(null).setEditor("expression"));
        CFT_SHOW_SYSTEM_TREE.addField(FieldFormat.create(CF_NODE_FILTER_EXPRESSION, 'S', Cres.get().getString(CF_NODE_FILTER_EXPRESSION)).setNullable(true).setEditor("expression"));
        CFT_SHOW_SYSTEM_TREE.addField("<componentLocation><T><F=NH><D=" + Cres.get().getString("componentLocation") + ">");
        CFT_SHOW_SYSTEM_TREE.addBinding("nodeClickExpression#hidden", Boolean.toString(true));
        CFT_SHOW_SYSTEM_TREE.addBinding("nodeFilterExpression#hidden", Boolean.toString(true));
    }
}

