/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.action.command;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.action.GenericActionCommand;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.util.DashboardProperties;
import com.tibbo.aggregate.common.util.DashboardsHierarchyInfo;
import com.tibbo.aggregate.common.util.WindowLocation;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class ShowHtmlSnippet
extends GenericActionCommand {
    public static final Pattern EXPRESSION_PATTERN = Pattern.compile("<e>(.|\\n)*?</e>");
    public static final int TYPE_FRAME = 0;
    public static final int TYPE_EXPRESSION = 1;
    public static final int TYPE_HTML = 2;
    public static final String CF_LOCATION = "location";
    public static final String CF_DASHBOARD = "dashboard";
    public static final String CF_KEY = "key";
    public static final String CF_TYPE = "snippetType";
    public static final String CF_URL = "url";
    public static final String CF_EXPRESSION = "expression";
    public static final String CF_HTML = "html";
    public static final String CF_CHECK_HTML_VALIDITY = "checkHtmlValidity";
    public static final String CF_DASHBOARDS_HIERARCHY_INFO = "dashboardsHierarchyInfo";
    public static final String CF_RESOURCE_BUNDLE = "resourceBundle";
    public static final TableFormat CFT_SHOW_HTML_SNIPPET = new TableFormat(1, 1);
    private WindowLocation location;
    private DashboardProperties dashboard;
    private String key;
    private String url;
    private Integer snippetType;
    private String html;
    private Boolean checkHtmlValidity;
    private String expression;
    private DashboardsHierarchyInfo dhInfo;
    private String resourceBundle;

    private static Map snippetTypes() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0, Cres.get().getString("wHtmlSnippetTypeFrame"));
        hashMap.put(1, Cres.get().getString("wHtmlSnippetTypeExpression"));
        hashMap.put(2, Cres.get().getString("wHtmlSnippetTypeHtml"));
        return hashMap;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(String resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public ShowHtmlSnippet() {
        super("showHtmlSnippet", CFT_SHOW_HTML_SNIPPET, null);
    }

    public ShowHtmlSnippet(String title, DataTable parameters) {
        super("showHtmlSnippet", title, parameters, CFT_SHOW_HTML_SNIPPET);
    }

    @Override
    protected DataTable constructParameters() {
        DataRecord rec = new DataRecord(CFT_SHOW_HTML_SNIPPET);
        rec.setValue(CF_TYPE, (Object)this.getSnippetType());
        rec.setValue(CF_URL, (Object)this.getUrl());
        rec.setValue(CF_LOCATION, this.getLocation() != null ? this.getLocation().toDataTable() : null);
        rec.setValue(CF_DASHBOARD, this.getDashboard() != null ? this.getDashboard().toDataTable() : null);
        rec.setValue(CF_KEY, (Object)this.getKey());
        rec.setValue(CF_DASHBOARDS_HIERARCHY_INFO, this.getDashboardsHierarchyInfo() != null ? this.getDashboardsHierarchyInfo().toDataTable() : null);
        rec.setValue(CF_HTML, (Object)this.getHtml());
        rec.setValue(CF_CHECK_HTML_VALIDITY, (Object)this.getCheckHtmlValidity());
        rec.setValue(CF_EXPRESSION, (Object)this.getExpression());
        rec.setValue(CF_RESOURCE_BUNDLE, (Object)this.getResourceBundle());
        rec.setValue("componentLocation", this.getComponentLocation() != null ? this.getComponentLocation().toDataTable() : null);
        return rec.wrap();
    }

    public WindowLocation getLocation() {
        return this.location;
    }

    public void setLocation(WindowLocation location) {
        this.location = location;
    }

    public DashboardProperties getDashboard() {
        return this.dashboard;
    }

    public void setDashboard(DashboardProperties dashboard) {
        this.dashboard = dashboard;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public DashboardsHierarchyInfo getDashboardsHierarchyInfo() {
        return this.dhInfo;
    }

    public void setDashboardsHierarchyInfo(DashboardsHierarchyInfo dhInfo) {
        this.dhInfo = dhInfo;
    }

    public Integer getSnippetType() {
        return this.snippetType;
    }

    public void setSnippetType(Integer snippetType) {
        this.snippetType = snippetType;
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Boolean getCheckHtmlValidity() {
        return this.checkHtmlValidity;
    }

    public void setCheckHtmlValidity(Boolean checkHtmlValidity) {
        this.checkHtmlValidity = checkHtmlValidity;
    }

    static {
        FieldFormat<Object> ff = FieldFormat.create(CF_TYPE, 'I', Cres.get().getString("wHtmlSnippetType"));
        CFT_SHOW_HTML_SNIPPET.addField(ff);
        ff.setSelectionValues(ShowHtmlSnippet.snippetTypes());
        ff = FieldFormat.create(CF_URL, 'S', Cres.get().getString("wURL"));
        ff.setNullable(true);
        CFT_SHOW_HTML_SNIPPET.addField(ff);
        ff = FieldFormat.create("<location><T><F=N>");
        ff.setDefault(new WindowLocation().toDataTable());
        CFT_SHOW_HTML_SNIPPET.addField(ff);
        ff = FieldFormat.create("<dashboard><T><F=N>");
        ff.setDefault(new DashboardProperties().toDataTable());
        CFT_SHOW_HTML_SNIPPET.addField(ff);
        CFT_SHOW_HTML_SNIPPET.addField("<key><S><F=NH><D=" + Cres.get().getString(CF_KEY) + ">");
        ff = FieldFormat.create("<dashboardsHierarchyInfo><T><F=N>");
        ff.setDefault(new DashboardsHierarchyInfo().toDataTable());
        CFT_SHOW_HTML_SNIPPET.addField(ff);
        ff = FieldFormat.create(CF_EXPRESSION, 'S', Cres.get().getString("wHtmlSnippetExpression"));
        ff.setNullable(true);
        ff.setEditor(CF_EXPRESSION);
        CFT_SHOW_HTML_SNIPPET.addField(ff);
        ff = FieldFormat.create(CF_HTML, 'S', Cres.get().getString("wHtmlSnippetHtml"));
        ff.setNullable(true);
        ff.setEditor("text");
        ff.setEditorOptions(CF_HTML);
        CFT_SHOW_HTML_SNIPPET.addField(ff);
        ff = FieldFormat.create("<resourceBundle><S><F=NRH>");
        CFT_SHOW_HTML_SNIPPET.addField(ff);
        ff = FieldFormat.create(CF_CHECK_HTML_VALIDITY, 'B', Cres.get().getString("wHtmlSnippetCheckHtmlValidity"), true);
        CFT_SHOW_HTML_SNIPPET.addField(ff);
        CFT_SHOW_HTML_SNIPPET.addField("<componentLocation><T><F=NH><D=" + Cres.get().getString("componentLocation") + ">");
        CFT_SHOW_HTML_SNIPPET.addBinding("url#hidden", "{snippetType} != 0");
        CFT_SHOW_HTML_SNIPPET.addBinding("expression#hidden", "{snippetType} != 1");
        CFT_SHOW_HTML_SNIPPET.addBinding("html#hidden", "{snippetType} != 2");
        CFT_SHOW_HTML_SNIPPET.addBinding("checkHtmlValidity#hidden", "{snippetType} != 2");
    }
}

