/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.action.command;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.action.GenericActionCommand;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.util.ComponentLocation;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ShowError
extends GenericActionCommand {
    public static final String CF_LEVEL = "level";
    public static final String CF_MESSAGE = "message";
    public static final String CF_EXCEPTION = "exception";
    public static final TableFormat CFT_SHOW_ERROR = new TableFormat(1, 1);
    private Throwable exception;
    private int level;
    private String message;

    public ShowError() {
        super("showError", CFT_SHOW_ERROR, null);
    }

    public ShowError(String title, String message, int level, Throwable exception) {
        super("showError", title);
        this.message = message;
        this.level = level;
        this.exception = exception;
    }

    public ShowError(String title, DataTable parameters) {
        super("showError", title, parameters);
    }

    @Override
    protected DataTable constructParameters() {
        SimpleDataTable t = new SimpleDataTable(CFT_SHOW_ERROR);
        StringWriter exTrace = new StringWriter();
        PrintWriter pw = new PrintWriter(exTrace);
        this.exception.printStackTrace(pw);
        String finalDetails = exTrace.toString();
        t.addRecord().addInt(this.level).addString(this.message).addString(finalDetails).addDataTable(this.getComponentLocation() != null ? this.getComponentLocation().toDataTable() : null);
        return t;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    static {
        CFT_SHOW_ERROR.addField("<level><I><D=" + Cres.get().getString(CF_LEVEL) + ">");
        CFT_SHOW_ERROR.addField("<message><S><F=N><D=" + Cres.get().getString(CF_MESSAGE) + ">");
        CFT_SHOW_ERROR.addField("<exception><S><F=N><D=" + Cres.get().getString(CF_EXCEPTION) + ">");
        CFT_SHOW_ERROR.addField(FieldFormat.create("componentLocation", 'T', Cres.get().getString("componentLocation")).setDefault(new SimpleDataTable(ComponentLocation.OFT_COMPONENT_LOCATION)).setNullable(true).setHidden(true));
    }
}

