/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.action.command;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.action.GenericActionCommand;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import java.util.LinkedHashMap;
import java.util.Map;

public class EditText
extends GenericActionCommand {
    public static final String CF_TEXT = "text";
    public static final String CF_MODE = "mode";
    public static final String RF_RESULT = "result";
    public static final String RF_TEXT = "text";
    public static final TableFormat CFT_EDIT_TEXT = new TableFormat(1, 1);
    public static final TableFormat RFT_EDIT_TEXT;
    private String text;
    private String mode;

    public static Map<String, String> modes() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("aggregate", Cres.get().getString("textEditorModeExpressionLanguage"));
        map.put("java", Cres.get().getString("textEditorModeJava"));
        map.put("xml", Cres.get().getString("textEditorModeXML"));
        map.put("sql", Cres.get().getString("textEditorModeSQL"));
        map.put("html", Cres.get().getString("textEditorModeHTML"));
        map.put("shellscript", Cres.get().getString("textEditorModeShellscript"));
        map.put("smi-mib", Cres.get().getString("textEditorModeSMIMIB"));
        map.put("typescript", Cres.get().getString("codeEditorModeTypeScript"));
        return map;
    }

    public EditText() {
        super("editText", CFT_EDIT_TEXT, RFT_EDIT_TEXT);
    }

    public EditText(String title, String text, String mode) {
        super("editText", title);
        this.text = text;
        this.mode = mode;
    }

    public EditText(String title, DataTable parameters) {
        super("editText", title, parameters, CFT_EDIT_TEXT);
    }

    @Override
    protected DataTable constructParameters() {
        return new SimpleDataTable(CFT_EDIT_TEXT, this.text, this.mode, this.getComponentLocation() != null ? this.getComponentLocation().toDataTable() : null);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    static {
        CFT_EDIT_TEXT.addField("<text><S><D=" + Cres.get().getString("text") + ">");
        FieldFormat<String> ff = FieldFormat.create("<mode><S><F=N><D=" + Cres.get().getString(CF_MODE) + ">").setSelectionValues(EditText.modes()).setExtendableSelectionValues(true).setDefaultOverride(true);
        CFT_EDIT_TEXT.addField(ff);
        CFT_EDIT_TEXT.addField("<componentLocation><T><F=NH><D=" + Cres.get().getString("componentLocation") + ">");
        RFT_EDIT_TEXT = new TableFormat(1, 1);
        RFT_EDIT_TEXT.addField("<result><S>");
        RFT_EDIT_TEXT.addField("<text><S><F=N>");
    }
}

