/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.action.command;

import com.tibbo.aggregate.common.action.ActionUtils;
import com.tibbo.aggregate.common.action.DefaultActionResult;
import com.tibbo.aggregate.common.action.GenericActionResponse;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import java.util.LinkedList;
import java.util.List;

public class EditPropertiesResult
extends DefaultActionResult {
    private final String code;
    private final List<String> changedProperties;

    public EditPropertiesResult(String code) {
        this(code, new LinkedList<String>());
    }

    public EditPropertiesResult(String code, List<String> changedProperties) {
        this.code = code;
        this.changedProperties = changedProperties;
    }

    public String getCode() {
        return this.code;
    }

    public List<String> getChangedProperties() {
        return this.changedProperties;
    }

    public static EditPropertiesResult parse(GenericActionResponse resp) {
        DataTable ps = resp.getParameters();
        if (ps == null || ps.getRecordCount() == 0) {
            return new EditPropertiesResult("closed");
        }
        String result = ps.rec().getString("result");
        ActionUtils.checkResponseCode(result);
        LinkedList<String> savedProperties = new LinkedList<String>();
        for (DataRecord rec : ps.rec().getDataTable("changedProperties")) {
            savedProperties.add(rec.getString("property"));
        }
        return new EditPropertiesResult(result, savedProperties);
    }
}

