/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.action.command;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.action.GenericActionCommand;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.util.DashboardProperties;
import com.tibbo.aggregate.common.util.DashboardsHierarchyInfo;
import com.tibbo.aggregate.common.util.WindowLocation;
import java.util.LinkedList;
import java.util.List;

public class EditProperties
extends GenericActionCommand {
    public static final String CF_READ_ONLY = "readOnly";
    public static final String CF_DYNAMIC = "dynamic";
    public static final String CF_ASYNC = "async";
    public static final String CF_USE_DOCKABLE_FRAME = "useDockableFrame";
    public static final String CF_SINGLE_WINDOW_MODE = "singleWindowMode";
    public static final String CF_CONTEXT = "context";
    public static final String CF_SLAVES = "slaves";
    public static final String CF_LOCATION = "location";
    public static final String CF_DASHBOARD = "dashboard";
    public static final String CF_KEY = "key";
    public static final String CF_DASHBOARDS_HIERARCHY_INFO = "dashboardsHierarchyInfo";
    public static final String CF_DEFAULT_GROUP = "defaultGroup";
    public static final String CF_ADDITIONAL_ACTIONS = "additionalActions";
    public static final String CF_ADDITIONAL_ACTIONS_VARIABLE_NAME = "variableName";
    public static final String CF_ADDITIONAL_ACTIONS_ACTION_NAME = "actionName";
    public static final String CF_ADDITIONAL_ACTIONS_ICON = "icon";
    public static final String CF_ADDITIONAL_ACTIONS_DESCRIPTION = "description";
    public static final String CF_ADDITIONAL_ACTIONS_ACTION = "action";
    public static final String CF_PROPERTIES = "properties";
    public static final String CF_PROPERTIES_GROUP = "propertiesGroup";
    public static final String RF_EDIT_PROPERTIES_RESULT = "result";
    public static final String RF_EDIT_PROPERTIES_CHANGED_PROPERTIES = "changedProperties";
    public static final String FIELD_PROPERTIES_PROPERTY = "property";
    public static final String CF_SLAVES_CONTEXT = "context";
    public static final TableFormat CFT_SLAVES = FieldFormat.create("<context><S>").wrap();
    public static final TableFormat FT_PROPERTIES = FieldFormat.create("<property><S><D=" + Cres.get().getString("property") + ">").wrap();
    public static final TableFormat CFT_ADDITIONAL_ACTIONS = new TableFormat();
    public static final TableFormat CFT_EDIT_PROPERTIES;
    public static final TableFormat RFT_EDIT_PROPERTIES;
    private String context;
    private String propertiesGroup;
    private List<String> properties;
    private List<String> slaves;
    private boolean readOnly;
    private boolean dynamic;
    private boolean useDockableFrame;
    private boolean singleWindowMode;
    private boolean async;
    private WindowLocation location;
    private DashboardProperties dashboard;
    private DashboardsHierarchyInfo dhInfo;
    private String key;
    private String defaultGroup;
    private DataTable additionalActions;

    public EditProperties() {
        super("editProperties", CFT_EDIT_PROPERTIES, RFT_EDIT_PROPERTIES);
    }

    public EditProperties(String title, String contextName, String propertiesGroup) {
        super("editProperties", title);
        this.context = contextName;
        this.propertiesGroup = propertiesGroup;
    }

    public EditProperties(String title, String contextName, List<String> properties) {
        super("editProperties", title);
        this.context = contextName;
        this.properties = properties;
    }

    public EditProperties(String title, DataTable parameters) {
        super("editProperties", title, parameters, CFT_EDIT_PROPERTIES);
    }

    @Override
    protected DataTable constructParameters() {
        DataTable slavesTable = this.createSlavesTable(this.slaves);
        SimpleDataTable table = new SimpleDataTable(CFT_EDIT_PROPERTIES);
        DataRecord rec = table.addRecord();
        rec.addString(this.context);
        rec.addString(this.propertiesGroup);
        SimpleDataTable propertiesTable = new SimpleDataTable(FT_PROPERTIES);
        if (this.properties != null) {
            for (String property : this.properties) {
                propertiesTable.addRecord().addString(property);
            }
        }
        rec.addDataTable(propertiesTable);
        rec.addBoolean(this.singleWindowMode);
        rec.addBoolean(this.useDockableFrame);
        rec.addBoolean(this.readOnly);
        rec.addBoolean(this.dynamic);
        rec.addBoolean(this.async);
        rec.addDataTable(slavesTable);
        rec.addDataTable(this.location != null ? this.location.toDataTable() : null);
        rec.addDataTable(this.dashboard != null ? this.dashboard.toDataTable() : null);
        rec.addString(this.key);
        rec.addDataTable(this.dhInfo != null ? this.dhInfo.toDataTable() : null);
        rec.addString(this.defaultGroup);
        rec.addDataTable(this.additionalActions);
        rec.addDataTable(this.getComponentLocation() != null ? this.getComponentLocation().toDataTable() : null);
        return rec.wrap();
    }

    private DataTable createSlavesTable(List<String> slaves) {
        if (slaves == null) {
            return null;
        }
        SimpleDataTable slavesTable = new SimpleDataTable(CFT_SLAVES);
        for (String slave : slaves) {
            slavesTable.addRecord().addString(slave);
        }
        return slavesTable;
    }

    public static List<Context> getSlaves(GenericActionCommand cmd, Context base, CallerController caller) {
        DataTable slavesTable = cmd.getParameters().rec().getDataTable(CF_SLAVES);
        if (slavesTable == null) {
            return null;
        }
        LinkedList<Context> slaves = new LinkedList<Context>();
        for (DataRecord rec : slavesTable) {
            String context = rec.getString("context");
            Object slave = base.get(context, caller);
            if (slave == null) continue;
            slaves.add((Context)slave);
        }
        return slaves;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String contextName) {
        this.context = contextName;
    }

    public String getPropertiesGroup() {
        return this.propertiesGroup;
    }

    public void setPropertiesGroup(String propertiesGroup) {
        this.propertiesGroup = propertiesGroup;
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public void setProperties(List<String> properties) {
        this.properties = properties;
    }

    public List<String> getSlaves() {
        return this.slaves;
    }

    public void setSlaves(List<String> slaves) {
        this.slaves = slaves;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isUseDockableFrame() {
        return this.useDockableFrame;
    }

    public void setUseDockableFrame(boolean useDockableFrame) {
        this.useDockableFrame = useDockableFrame;
    }

    public boolean isSingleWindowMode() {
        return this.singleWindowMode;
    }

    public void setSingleWindowMode(boolean singleWindowMode) {
        this.singleWindowMode = singleWindowMode;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public WindowLocation getLocation() {
        return this.location;
    }

    public void setLocation(WindowLocation location) {
        this.location = location;
    }

    public DashboardProperties getDashboard() {
        return this.dashboard;
    }

    public void setDashboard(DashboardProperties dashboard) {
        this.dashboard = dashboard;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public DashboardsHierarchyInfo getDashboardsHierarchyInfo() {
        return this.dhInfo;
    }

    public void setDashboardsHierarchyInfo(DashboardsHierarchyInfo dhInfo) {
        this.dhInfo = dhInfo;
    }

    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    public void setDefaultGroup(String group) {
        this.defaultGroup = group;
    }

    public void setAdditionalActions(DataTable additionalActions) {
        this.additionalActions = additionalActions;
    }

    public DataTable getAdditionalActions() {
        return this.additionalActions;
    }

    static {
        CFT_ADDITIONAL_ACTIONS.addField('S', CF_ADDITIONAL_ACTIONS_VARIABLE_NAME, Cres.get().getString("wVariableName"));
        CFT_ADDITIONAL_ACTIONS.addField('S', CF_ADDITIONAL_ACTIONS_ACTION_NAME, Cres.get().getString(CF_ADDITIONAL_ACTIONS_ACTION_NAME));
        CFT_ADDITIONAL_ACTIONS.addField('S', CF_ADDITIONAL_ACTIONS_ICON, Cres.get().getString(CF_ADDITIONAL_ACTIONS_ICON));
        CFT_ADDITIONAL_ACTIONS.addField('S', CF_ADDITIONAL_ACTIONS_DESCRIPTION, Cres.get().getString(CF_ADDITIONAL_ACTIONS_DESCRIPTION), null, true);
        CFT_ADDITIONAL_ACTIONS.addField('S', CF_ADDITIONAL_ACTIONS_ACTION, Cres.get().getString(CF_ADDITIONAL_ACTIONS_ACTION), null, true);
        CFT_EDIT_PROPERTIES = new TableFormat(1, 1);
        CFT_EDIT_PROPERTIES.addField("<context><S><D=" + Cres.get().getString("context") + "><E=" + "context" + ">");
        CFT_EDIT_PROPERTIES.addField("<propertiesGroup><S><F=N><D=" + Cres.get().getString("group") + ">");
        FieldFormat properties = FieldFormat.create("<properties><T><D=" + Cres.get().getString(CF_PROPERTIES) + ">");
        properties.setDefault(new SimpleDataTable(FT_PROPERTIES, true));
        CFT_EDIT_PROPERTIES.addField(properties);
        CFT_EDIT_PROPERTIES.addField("<singleWindowMode><B><D=" + Cres.get().getString("acSingleWindowMode") + ">");
        CFT_EDIT_PROPERTIES.addField("<useDockableFrame><B><D=" + Cres.get().getString("acUseDockableFrame") + ">");
        CFT_EDIT_PROPERTIES.addField("<readOnly><B><D=" + Cres.get().getString("acInitiallyReadOnly") + ">");
        CFT_EDIT_PROPERTIES.addField("<dynamic><B><D=" + Cres.get().getString(CF_DYNAMIC) + ">");
        CFT_EDIT_PROPERTIES.addField("<async><B><D=" + Cres.get().getString("acDoNotWaitClosure") + ">");
        CFT_EDIT_PROPERTIES.addField("<slaves><T><F=NH>");
        CFT_EDIT_PROPERTIES.addField("<location><T><F=NH>");
        CFT_EDIT_PROPERTIES.addField("<dashboard><T><F=NH>");
        CFT_EDIT_PROPERTIES.addField("<key><S><F=NH><D=" + Cres.get().getString(CF_KEY) + ">");
        CFT_EDIT_PROPERTIES.addField("<dashboardsHierarchyInfo><T><F=NH>");
        CFT_EDIT_PROPERTIES.addField('S', CF_DEFAULT_GROUP, Cres.get().getString(CF_DEFAULT_GROUP), null, true);
        CFT_EDIT_PROPERTIES.addField('T', CF_ADDITIONAL_ACTIONS, Cres.get().getString(CF_ADDITIONAL_ACTIONS), (Object)new SimpleDataTable(CFT_ADDITIONAL_ACTIONS), true);
        CFT_EDIT_PROPERTIES.addField("<componentLocation><T><F=NH><D=" + Cres.get().getString("componentLocation") + ">");
        String ref = "properties#enabled";
        String exp = "{propertiesGroup} == null";
        CFT_EDIT_PROPERTIES.addBinding(ref, exp);
        RFT_EDIT_PROPERTIES = new TableFormat(1, 1);
        RFT_EDIT_PROPERTIES.addField("<result><S>");
        FieldFormat changedProperties = FieldFormat.create("<changedProperties><T>");
        changedProperties.setDefault(new SimpleDataTable(FT_PROPERTIES, true));
        RFT_EDIT_PROPERTIES.addField(changedProperties);
    }
}

