/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.action.command;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.action.GenericActionCommand;
import com.tibbo.aggregate.common.action.GenericActionResponse;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import java.util.LinkedHashMap;

public class Confirm
extends GenericActionCommand {
    public static final String CF_MESSAGE = "message";
    public static final String CF_OPTION_TYPE = "optionType";
    public static final String CF_MESSAGE_TYPE = "messageType";
    public static final String RF_OPTION = "option";
    public static final TableFormat CFT_CONFIRM = new TableFormat(1, 1);
    public static final TableFormat RFT_CONFIRM;
    private String message;
    private int optionType;
    private int messageType;

    public Confirm() {
        super("confirm", CFT_CONFIRM, RFT_CONFIRM);
    }

    public Confirm(String message) {
        this(Cres.get().getString("confirmation"), message, 0, 3);
    }

    public Confirm(String title, String message, int optionType, int messageType) {
        super("confirm", title);
        this.message = message;
        this.optionType = optionType;
        this.messageType = messageType;
    }

    public Confirm(String title, DataTable parameters) {
        super("confirm", title, parameters, CFT_CONFIRM);
    }

    @Override
    public DataTable constructParameters() {
        return new DataRecord(CFT_CONFIRM).addString(this.message).addInt(this.optionType).addInt(this.messageType).wrap();
    }

    @Override
    public GenericActionResponse createDefaultResponse() {
        TableFormat responseFormat = RFT_CONFIRM.clone();
        LinkedHashMap<Integer, String> selectionValues = new LinkedHashMap<Integer, String>();
        int optionType = this.getParameters().rec().getInt(CF_OPTION_TYPE);
        if (0 == optionType) {
            selectionValues.put(0, Cres.get().getString("yes"));
            selectionValues.put(1, Cres.get().getString("no"));
        } else if (2 == optionType) {
            selectionValues.put(0, Cres.get().getString("ok"));
            selectionValues.put(2, Cres.get().getString("cancel"));
        } else if (1 == optionType) {
            selectionValues.put(0, Cres.get().getString("yes"));
            selectionValues.put(1, Cres.get().getString("no"));
            selectionValues.put(2, Cres.get().getString("cancel"));
        } else {
            throw new IllegalStateException("Unsupported option type: " + optionType);
        }
        selectionValues.put(-1, Cres.get().getString("close"));
        responseFormat.getField(RF_OPTION).setSelectionValues(selectionValues);
        return new GenericActionResponse(new SimpleDataTable(responseFormat, true));
    }

    public static int parseConfirm(GenericActionResponse resp) {
        DataTable t;
        DataTable dataTable = t = resp != null ? resp.getParameters() : null;
        if (t == null || t.getRecordCount() == 0) {
            return 2;
        }
        if (!t.getFormat().hasField(RF_OPTION)) {
            throw new IllegalArgumentException("Malformed response");
        }
        int option = t.rec().getInt(RF_OPTION);
        switch (option) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal response option: " + option);
            }
        }
        return option;
    }

    public String getMessage() {
        return this.message;
    }

    public int getOptionType() {
        return this.optionType;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setOptionType(int optionType) {
        this.optionType = optionType;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    static {
        CFT_CONFIRM.addField("<message><S><D=" + Cres.get().getString(CF_MESSAGE) + ">");
        CFT_CONFIRM.addField("<optionType><I><D=" + Cres.get().getString("acOptionType") + ">");
        CFT_CONFIRM.addField("<messageType><I><D=" + Cres.get().getString("acMessageType") + ">");
        RFT_CONFIRM = new TableFormat(1, 1, "<option><I><D=" + Cres.get().getString(RF_OPTION) + ">");
    }
}

