/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.action;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.action.Action;
import com.tibbo.aggregate.common.action.ActionCommand;
import com.tibbo.aggregate.common.action.ActionContext;
import com.tibbo.aggregate.common.action.ActionDefinition;
import com.tibbo.aggregate.common.action.ActionExecutionMode;
import com.tibbo.aggregate.common.action.ActionIdentifier;
import com.tibbo.aggregate.common.action.ActionManager;
import com.tibbo.aggregate.common.action.ActionResponse;
import com.tibbo.aggregate.common.action.ActionResult;
import com.tibbo.aggregate.common.action.InitialRequest;
import com.tibbo.aggregate.common.action.SequentialAction;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.device.DisconnectionException;
import java.util.concurrent.Semaphore;

public abstract class SingleThreadAction<I extends InitialRequest, C extends ActionCommand, R extends ActionResponse>
extends SequentialAction<I, C, R> {
    private static final int BINARY_SEMAPHOR_CAPACITY = 1;
    private ActionContext actionContext;
    private ActionThread executionThread;
    private final Semaphore waitCommand = new Semaphore(1, true);
    private final Semaphore waitResponse = new Semaphore(1, true);
    private ActionCommand lastCommand;
    private R lastResponse;
    private boolean destroyActionInThreadRun = true;

    @Override
    public final synchronized void init(ActionContext actionContext, I initialParameters) {
        if (this.executionThread != null) {
            throw new IllegalStateException("Already initialized");
        }
        if (actionContext == null) {
            throw new NullPointerException();
        }
        this.actionContext = actionContext;
        try {
            this.waitCommand.acquire(1);
            this.waitResponse.acquire(1);
        }
        catch (InterruptedException ex) {
            throw new ExceptionInInitializerError(ex);
        }
        this.executionThread = new ActionThread("Action / " + this);
        this.executionThread.setActionRequest(initialParameters);
    }

    public String toString() {
        return this.getActionContext().getActionDefinition().toString();
    }

    @Override
    protected R send(C actionCommand) throws DisconnectionException {
        if (actionCommand == null) {
            throw new NullPointerException();
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new DisconnectionException(Cres.get().getString("interrupted"));
        }
        this.lastCommand = actionCommand;
        this.waitCommand.release();
        try {
            this.waitResponse.acquire();
        }
        catch (InterruptedException ex) {
            throw new DisconnectionException(Cres.get().getString("interrupted"));
        }
        return this.lastResponse;
    }

    @Override
    public final synchronized C service(R actionRequest) {
        boolean newThread;
        if (this.executionThread == null) {
            throw new IllegalStateException();
        }
        if (this.lastCommand != null) {
            if (!this.lastCommand.isResponseValid((ActionResponse)actionRequest)) {
                throw new IllegalArgumentException("Action response " + actionRequest + " doesn't match last command " + this.lastCommand);
            }
            this.lastCommand = null;
        }
        boolean bl = newThread = Thread.State.NEW == this.executionThread.getState();
        if (newThread) {
            this.executionThread.start();
        }
        try {
            if (Thread.currentThread() == this.executionThread) {
                throw new IllegalThreadStateException("Call to service() from the execution thread");
            }
            if (!this.executionThread.isAlive()) {
                throw new IllegalThreadStateException("Execution thread has finished");
            }
            this.lastResponse = newThread ? null : actionRequest;
            if (!newThread) {
                this.waitResponse.release();
            }
            this.waitCommand.acquire();
            return (C)this.lastCommand;
        }
        catch (InterruptedException e) {
            Log.CONTEXT_ACTIONS.info((Object)"Action was destroyed", (Throwable)e);
            return null;
        }
        catch (Throwable t) {
            this.executionThread.interrupt();
            throw new RuntimeException("Error servicing action command: " + t.getMessage(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActionResult redirect(ActionDefinition actionDefinition, I initialRequest) throws DisconnectionException {
        ActionManager actionManager = this.actionContext.getActionManager();
        ActionDefinition currentActionDefinition = this.actionContext.getActionDefinition();
        try {
            this.actionContext.setActionDefinition(actionDefinition);
            ActionIdentifier actionId = actionManager.initAction(this.actionContext, (InitialRequest)initialRequest, new ActionExecutionMode(1), null);
            ActionResult actionResult = this.redirectById(actionId);
            return actionResult;
        }
        finally {
            this.actionContext.setActionDefinition(currentActionDefinition);
        }
    }

    protected ActionResult redirectById(ActionIdentifier actionId) throws DisconnectionException {
        ActionManager actionManager = this.actionContext.getActionManager();
        this.disableActionDestructionInThreadRun(actionId, actionManager);
        try {
            ActionCommand cmd = actionManager.service(actionId, null);
            while (cmd != null) {
                R actionRequest = this.send(cmd);
                cmd = actionManager.service(actionId, (ActionResponse)actionRequest);
            }
        }
        catch (Exception e) {
            this.processError(e);
        }
        return actionManager.destroyAction(actionId);
    }

    private void disableActionDestructionInThreadRun(ActionIdentifier actionId, ActionManager actionManager) {
        Action action = actionManager.getAction(actionId);
        if (action instanceof SingleThreadAction) {
            SingleThreadAction singleThreadAction = (SingleThreadAction)action;
            singleThreadAction.setDestroyActionInThreadRun(false);
        }
    }

    protected void processError(Throwable ex) {
        Log.CONTEXT_ACTIONS.warn((Object)"Error during action execution", ex);
    }

    private void setDestroyActionInThreadRun(boolean destroyActionInThreadRun) {
        this.destroyActionInThreadRun = destroyActionInThreadRun;
    }

    @Override
    public final synchronized ActionResult destroy() {
        if (this.executionThread != null) {
            this.executionThread.interrupt();
        }
        ActionResult actionResult = this.executionThread != null ? this.executionThread.getActionResult() : null;
        this.executionThread = null;
        this.lastCommand = null;
        this.lastResponse = null;
        this.waitCommand.release();
        this.waitResponse.release();
        return actionResult;
    }

    protected ActionContext getActionContext() {
        return this.actionContext;
    }

    class ActionThread
    extends Thread {
        private I initialRequest;
        private ActionResult actionResult;

        public ActionThread(String name) {
            super(name);
        }

        public void setActionRequest(I actionRequest) {
            if (!(actionRequest instanceof InitialRequest)) {
                throw new IllegalArgumentException("actionRequest should be InitialRequest");
            }
            this.initialRequest = actionRequest;
        }

        public ActionResult getActionResult() {
            return this.actionResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ActionDefinition def = SingleThreadAction.this.actionContext.getActionDefinition();
            ContextManager cm = SingleThreadAction.this.actionContext.getDefiningContext().getContextManager();
            Object utilitiesContext = cm.get("utilities", SingleThreadAction.this.actionContext.getCallerController());
            String actionId = SingleThreadAction.this.actionContext.getActionManager().getActionID(SingleThreadAction.this).getId();
            TableFormat tf = utilitiesContext.getEventDefinition("actionFinished").getFormat();
            SimpleDataTable eventData = new SimpleDataTable(tf, 1);
            if (!def.isConcurrent()) {
                def.getExecutionLock().lock();
            }
            try {
                this.actionResult = SingleThreadAction.this.invoke(this.initialRequest);
                DataTable resultTable = null;
                if (this.actionResult != null) {
                    resultTable = this.actionResult.getResult();
                }
                eventData.rec().setValue("actionId", (Object)actionId).setValue("actionResult", (Object)resultTable);
                utilitiesContext.fireEvent("actionFinished", SingleThreadAction.this.actionContext.getCallerController(), (DataTable)eventData);
            }
            catch (Throwable ex) {
                SingleThreadAction.this.processError(ex);
            }
            finally {
                if (!def.isConcurrent()) {
                    def.getExecutionLock().unlock();
                }
                SingleThreadAction.this.waitCommand.release();
                if (SingleThreadAction.this.destroyActionInThreadRun) {
                    this.destroyActionInThreadRun();
                }
            }
        }

        private void destroyActionInThreadRun() {
            ActionIdentifier actionID;
            ActionManager actionManager = SingleThreadAction.this.actionContext.getActionManager();
            ActionIdentifier actionIdentifier = actionID = actionManager != null ? actionManager.getActionID(SingleThreadAction.this) : null;
            if (actionID != null) {
                actionManager.destroyAction(actionID);
            }
        }
    }
}

