/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.action;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.action.Action;
import com.tibbo.aggregate.common.action.ActionContext;
import com.tibbo.aggregate.common.action.ActionDefinition;
import com.tibbo.aggregate.common.action.ActionExecutionMode;
import com.tibbo.aggregate.common.action.ActionHistoryItem;
import com.tibbo.aggregate.common.action.ActionHolder;
import com.tibbo.aggregate.common.action.ActionIdentifier;
import com.tibbo.aggregate.common.action.ActionManager;
import com.tibbo.aggregate.common.action.ActionUtils;
import com.tibbo.aggregate.common.action.BatchEntry;
import com.tibbo.aggregate.common.action.GenericActionCommand;
import com.tibbo.aggregate.common.action.GenericActionResponse;
import com.tibbo.aggregate.common.action.GroupIdentifier;
import com.tibbo.aggregate.common.action.RequestCache;
import com.tibbo.aggregate.common.action.RequestIdentifier;
import com.tibbo.aggregate.common.action.ServerActionCommandProcessor;
import com.tibbo.aggregate.common.action.ServerActionContext;
import com.tibbo.aggregate.common.action.ServerActionDefinition;
import com.tibbo.aggregate.common.action.ServerActionInput;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableUtils;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.server.ServerContext;
import com.tibbo.aggregate.common.util.ErrorCollector;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ServerActionHelper {
    public static final String ENV_VARIABLE_PARAMETERS = "parameters";
    private static final String FIELD_CONTEXT = "context";
    private static final String FIELD_SELECT = "select";
    private static final TableFormat CONTEXTS_FORMAT = new TableFormat();

    public static Map<String, String> executeNonInteractively(Context context, String action, DataTable initialParameters, DataTable inputData, Map<String, Object> environment, ActionExecutionMode mode, CallerController caller) throws ContextException {
        GenericActionCommand cmd;
        LinkedHashMap<String, String> messages = new LinkedHashMap<String, String>();
        ActionDefinition def = context.getActionDefinition(action, caller);
        if (def == null) {
            String message = MessageFormat.format(Cres.get().getString("conActNotAvailExt"), action, context.toString());
            messages.put(message, null);
            return messages;
        }
        Log.CONTEXT_ACTIONS.debug((Object)("Executing action '" + action + "' from context '" + context + "' non-interactively"));
        ErrorCollector collector = new ErrorCollector();
        ActionIdentifier actionId = ActionUtils.initAction(context, action, new ServerActionInput(initialParameters), inputData, environment, mode, caller, collector);
        for (Exception error : collector.getErrors()) {
            messages.put(error.getMessage(), error.toString());
        }
        if (!collector.getErrors().isEmpty()) {
            return messages;
        }
        while ((cmd = ActionUtils.stepAction(context, actionId, null, caller)) != null && !cmd.isLast()) {
            Log.CONTEXT_ACTIONS.debug((Object)("Action returned command: actionId=" + actionId + ", type=" + cmd.getType() + ", title=" + cmd.getTitle()));
            if (!"showError".equals(cmd.getType())) continue;
            DataRecord rec = cmd.getParameters().rec();
            String message = rec.getString("message");
            String exception = rec.getString("exception");
            messages.put(message, exception);
            Log.CONTEXT_ACTIONS.debug((Object)("Action returned error response: " + message + " (" + exception + ")"));
        }
        return messages;
    }

    public static void fillRequestCache(ActionContext actionContext, DataTable initialParameters, DataTable inputData, Map<String, Object> environment, CallerController caller, ContextManager cm, Context con, ErrorCollector collector) {
        if (inputData == null) {
            return;
        }
        RequestCache requestCache = actionContext.getRequestCache();
        if (requestCache == null) {
            requestCache = new RequestCache();
            actionContext.setRequestCache(requestCache);
        }
        if (inputData.getRecordCount() > 0) {
            DataRecord rec = inputData.rec();
            for (FieldFormat ff : rec.getFormat()) {
                String requestId = ff.getName();
                GenericActionResponse req = ServerActionHelper.buildResponse(requestId, initialParameters, rec.getDataTable(requestId), environment, caller, cm, con, collector);
                requestCache.getRequests().put(new RequestIdentifier(requestId), req);
            }
        }
    }

    private static GenericActionResponse buildResponse(String requestId, DataTable initialParameters, DataTable responseData, Map<String, Object> environment, CallerController caller, ContextManager cm, Context con, ErrorCollector collector) {
        GenericActionResponse req = new GenericActionResponse(responseData, false, new RequestIdentifier(requestId));
        if (!responseData.getFormat().getBindings().isEmpty()) {
            Evaluator evaluator = new Evaluator(cm, con, responseData, caller);
            if (environment != null) {
                for (Map.Entry<String, Object> entry : environment.entrySet()) {
                    evaluator.getEnvironmentResolver().set(entry.getKey(), entry.getValue());
                }
            }
            evaluator.getEnvironmentResolver().set(ENV_VARIABLE_PARAMETERS, initialParameters);
            DataTableUtils.processBindings(responseData, evaluator, collector);
        }
        return req;
    }

    public static ActionIdentifier initAction(ServerContext source, String action, CallerController caller, DataTable initialParameters, DataTable inputData, Map<String, Object> environment, ActionExecutionMode mode, ErrorCollector collector, String customActionId) throws ContextException {
        ActionDefinition actionDef;
        boolean asDefault = false;
        if (action == null) {
            asDefault = true;
            List<ActionDefinition> actions = source.getActionDefinitions(caller);
            for (ActionDefinition ad : actions) {
                if (!ad.isDefault()) continue;
                action = ad.getName();
            }
            if (action == null) {
                throw new ContextException("Default action not available in context '" + source.toDetailedString() + "'");
            }
        }
        if ((actionDef = source.getActionDefinition(action, caller)) == null) {
            throw new ContextException("Action '" + action + "' not available in context '" + source.toDetailedString() + "'");
        }
        ActionIdentifier actionId = source.initAction(actionDef, new ServerActionInput(initialParameters), mode, caller, customActionId, asDefault);
        ActionContext actionContext = caller.getCallerData().getActionManager().getActionContext(actionId);
        actionContext.setExecutedAsDefault(asDefault);
        ServerActionHelper.fillRequestCache(actionContext, initialParameters, inputData, environment, caller, source.getContextManager(), source, collector);
        caller.getCallerData().addToActionHistory(new ActionHistoryItem(new Date(), source.getPath(), action, initialParameters));
        return actionId;
    }

    public static ActionIdentifier initActions(CallerController caller, List<ActionHolder> actions, ServerContext con) throws ContextException {
        ActionManager actionManager = caller.getCallerData().getActionManager();
        LinkedList<BatchEntry> entries = new LinkedList<BatchEntry>();
        for (int i = 0; i < actions.size(); ++i) {
            ActionHolder holder = actions.get(i);
            ServerContext context = holder.getContext();
            String actionName = holder.getActionName();
            if (actionName == null) {
                throw new IllegalArgumentException("Action name is null");
            }
            ActionDefinition actionDef = context.getActionDefinition(actionName);
            if (actionDef == null) {
                throw new ContextException("Unsupported action '" + actionName + "' for context '" + context.getPath() + "'");
            }
            ServerActionContext actionContext = new ServerActionContext(actionDef, context, caller);
            ServerActionInput initialParameters = new ServerActionInput(holder.getInitialParameters(), i == actions.size() - 1);
            ServerActionHelper.fillRequestCache(actionContext, holder.getInitialParameters(), holder.getInputData(), null, caller, con.getContextManager(), con, null);
            caller.getCallerData().addToActionHistory(new ActionHistoryItem(new Date(), context.getPath(), actionName, holder.getInitialParameters()));
            entries.add(new BatchEntry(actionContext, initialParameters));
        }
        ServerActionDefinition stub = new ServerActionDefinition(null, Action.class){

            @Override
            public GroupIdentifier getExecutionGroup() {
                return null;
            }
        };
        return actionManager.initActions(entries, new ServerActionContext(stub, con, caller));
    }

    public static VariableDefinition selectVariable(String description, Context context, ServerActionCommandProcessor processor, CallerController caller, String iconId, String helpId) {
        List<VariableDefinition> vars = context.getVariableDefinitions(caller);
        vars.removeIf(vd -> vd.getGroup() == null);
        if (vars.isEmpty()) {
            processor.showMessage(description, Cres.get().getString("acNoVariables"));
            return null;
        }
        if (vars.size() == 1) {
            return vars.get(0);
        }
        String variableNameField = "variable";
        FieldFormat ff = FieldFormat.create("variable", 'S');
        ff.setDescription(Cres.get().getString("variable"));
        ff.setEditor("list");
        LinkedHashMap<String, String> selValues = new LinkedHashMap<String, String>();
        for (VariableDefinition var : vars) {
            selValues.put(var.getName(), var.toString());
        }
        ff.setSelectionValues(selValues);
        ff.setExtendableSelectionValues(false);
        TableFormat rf = new TableFormat(ff);
        rf.setMinRecords(1);
        rf.setMaxRecords(1);
        DataTable table = new SimpleDataTable(rf, true);
        table = processor.editData(description, table, iconId, helpId, null, null);
        if (table == null) {
            return null;
        }
        return context.getVariableDefinition(table.rec().getString("variable"));
    }

    public static FieldFormat selectField(String description, TableFormat format, ServerActionCommandProcessor processor, CallerController caller, String iconId, String helpId) {
        FieldFormat ff2;
        if (format == null) {
            return null;
        }
        LinkedList<FieldFormat> fields = new LinkedList<FieldFormat>();
        for (FieldFormat ff2 : format) {
            if (ff2.isHidden()) continue;
            fields.add(ff2);
        }
        if (fields.isEmpty()) {
            processor.showMessage(description, Cres.get().getString("acNoFields"));
            return null;
        }
        if (fields.size() == 1) {
            return (FieldFormat)fields.get(0);
        }
        String fieldNameField = "field";
        ff2 = FieldFormat.create("field", 'S');
        ff2.setDescription(Cres.get().getString("field"));
        ff2.setEditor("list");
        LinkedHashMap<String, String> selValues = new LinkedHashMap<String, String>();
        for (FieldFormat cff : fields) {
            selValues.put(cff.getName(), cff.toString());
        }
        ff2.setSelectionValues(selValues);
        ff2.setExtendableSelectionValues(false);
        TableFormat rf = new TableFormat(ff2);
        rf.setMinRecords(1);
        rf.setMaxRecords(1);
        DataTable table = new SimpleDataTable(rf, true);
        table = processor.editData(description, table, iconId, helpId, null, null);
        if (table == null) {
            return null;
        }
        return format.getField(table.rec().getString("field"));
    }

    public static Integer selectOption(String description, Map<Integer, String> options, Integer defaultOption, ServerActionCommandProcessor processor) {
        String fieldName = "option";
        FieldFormat ff = FieldFormat.create("option", 'I');
        ff.setDescription(description);
        ff.setEditor("list");
        ff.setSelectionValues(options);
        if (defaultOption != null) {
            ff.setDefault(defaultOption);
        }
        TableFormat rf = new TableFormat(ff);
        rf.setMinRecords(1);
        rf.setMaxRecords(1);
        DataTable table = new SimpleDataTable(rf, true);
        table = processor.editData(description, table, null);
        if (table == null) {
            return null;
        }
        return table.rec().getInt("option");
    }

    public static Collection<Context> selectContexts(String description, Collection<Context> contexts, ContextManager cm, CallerController cc, ServerActionCommandProcessor processor) {
        DataTable data = new SimpleDataTable(CONTEXTS_FORMAT);
        for (Context con : contexts) {
            data.addRecord(con.getPath(), true);
        }
        if ((data = processor.editData(description, data, null)) == null) {
            return null;
        }
        LinkedHashSet<Context> res = new LinkedHashSet<Context>();
        for (DataRecord rec : data) {
            Object con;
            if (!rec.getBoolean(FIELD_SELECT).booleanValue() || (con = cm.get(rec.getString(FIELD_CONTEXT), cc)) == null) continue;
            res.add((Context)con);
        }
        return res;
    }

    public static DataRecord getEntityRelatedModeRecord(ServerActionInput parameters) {
        DataTable record;
        DataTable ininitialParameters = parameters.getData();
        if (ininitialParameters != null && ininitialParameters.getFormat().hasField("record") && (record = ininitialParameters.rec().getDataTable("record")) != null) {
            return record.rec();
        }
        return null;
    }

    static {
        CONTEXTS_FORMAT.setUnresizable(true);
        CONTEXTS_FORMAT.addField(FieldFormat.create(FIELD_CONTEXT, 'S', Cres.get().getString(FIELD_CONTEXT)).setEditor(FIELD_CONTEXT).setReadonly(true));
        CONTEXTS_FORMAT.addField(FieldFormat.create(FIELD_SELECT, 'B', Cres.get().getString(FIELD_SELECT), true));
    }
}

