/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.action;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.action.ActionDefinition;
import com.tibbo.aggregate.common.action.ActionHolder;
import com.tibbo.aggregate.common.action.ActionIdentifier;
import com.tibbo.aggregate.common.action.ActionResponse;
import com.tibbo.aggregate.common.action.ActionResult;
import com.tibbo.aggregate.common.action.ActionUtils;
import com.tibbo.aggregate.common.action.GenericActionCommand;
import com.tibbo.aggregate.common.action.GenericActionResponse;
import com.tibbo.aggregate.common.action.LaunchDashboardAction;
import com.tibbo.aggregate.common.action.RequestCache;
import com.tibbo.aggregate.common.action.RequestIdentifier;
import com.tibbo.aggregate.common.action.ServerActionCommandProcessor;
import com.tibbo.aggregate.common.action.ServerActionContext;
import com.tibbo.aggregate.common.action.ServerActionHelper;
import com.tibbo.aggregate.common.action.ServerActionInput;
import com.tibbo.aggregate.common.action.SingleThreadAction;
import com.tibbo.aggregate.common.action.command.ShowMessage;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.device.DisconnectionException;
import com.tibbo.aggregate.common.server.ServerContext;
import com.tibbo.aggregate.common.util.Util;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class ServerAction
extends SingleThreadAction<ServerActionInput, GenericActionCommand, GenericActionResponse> {
    private final ServerActionCommandProcessor processor = new ServerActionCommandProcessor(this);

    @Override
    public GenericActionResponse send(GenericActionCommand actionCommand) throws DisconnectionException {
        return (GenericActionResponse)super.send(actionCommand);
    }

    public ServerActionCommandProcessor getProcessor() {
        return this.processor;
    }

    @Override
    protected ServerActionContext getActionContext() {
        return (ServerActionContext)super.getActionContext();
    }

    protected ActionDefinition getActionDefinition() {
        return this.getActionContext().getActionDefinition();
    }

    public ServerContext getDefiningContext() {
        return this.getActionContext().getDefiningContext();
    }

    public DataTable getParameter(ServerActionInput input, String name) {
        ActionResponse acmd;
        RequestCache cache;
        RequestCache requestCache = cache = this.getActionContext() != null ? this.getActionContext().getRequestCache() : null;
        if (cache != null && (acmd = cache.getRequest(new RequestIdentifier(name))) != null && acmd instanceof GenericActionCommand) {
            GenericActionCommand gac = (GenericActionCommand)((Object)acmd);
            return gac.getParameters();
        }
        return ServerActionCommandProcessor.getExecutionParameter(input.getData(), name);
    }

    public CallerController getCallerController() {
        return this.getActionContext().getCallerController();
    }

    @Override
    public ActionResult invoke(ServerActionInput parameters) throws ContextException {
        if (this.getActionContext() != null && this.getActionContext().isExecutedAsDefault() && this.getActionContext().getActionExecutionMode().getCode() != 1 && this.executeDefaultSubstitutors(parameters)) {
            return null;
        }
        return this.execute(parameters);
    }

    protected abstract ActionResult execute(ServerActionInput var1) throws ContextException;

    protected boolean executeDefaultSubstitutors(ServerActionInput parameters) throws ContextException {
        ServerContext con = this.getDefiningContext();
        boolean found = false;
        List<ActionDefinition> actions = con.getActionDefinitions(this.getCallerController());
        for (ActionDefinition ad : actions) {
            ActionResult res;
            LaunchDashboardAction oda;
            if (!(ad instanceof LaunchDashboardAction) || this.getCallerController().getType().equals((Object)CallerController.Type.DESKTOP) || !(oda = (LaunchDashboardAction)((Object)ad)).isDefaultActionSubstitutor(con, this.getCallerController()) || (res = this.redirect(con, ad.getName(), parameters)) != null && !res.isSuccessful()) continue;
            found = true;
        }
        return found;
    }

    public ActionResult redirect(ServerContext ctx, String action, ServerActionInput input) throws ContextException {
        return this.redirect(ctx, ctx.getActionDefinition(action), input);
    }

    public ActionResult redirect(ServerContext ctx, ActionDefinition def, ServerActionInput input) throws ContextException {
        ServerActionContext actionContext = this.getActionContext();
        ServerContext prevCtx = actionContext.getDefiningContext();
        actionContext.setDefiningContext(ctx);
        try {
            ActionResult actionResult = super.redirect(def, input);
            return actionResult;
        }
        catch (DisconnectionException ex) {
            throw new ContextException(ex);
        }
        finally {
            actionContext.setDefiningContext(prevCtx);
        }
    }

    public ActionResult call(ServerContext devicesContext, ActionDefinition def, ServerActionInput serverActionInput) {
        return null;
    }

    public void redirectToGroupedAction(ServerContext ctx, List<Context> contexts, String action, CallerController caller, DataTable executionParameters) throws ContextException, DisconnectionException {
        LinkedList<ActionHolder> actions = new LinkedList<ActionHolder>();
        for (Context con : contexts) {
            ActionHolder holder = new ActionHolder();
            holder.setContext((ServerContext)con);
            holder.setActionName(action);
            holder.setInitialParameters(executionParameters);
            actions.add(holder);
        }
        ActionIdentifier actionId = ServerActionHelper.initActions(caller, actions, ctx);
        this.redirectById(actionId);
    }

    protected void executeInteractively(String operationName, ServerContext ctx, List<Context> contexts, String action, DataTable executionParameters) throws ContextException, DisconnectionException {
        ActionDefinition ad = null;
        Iterator<Context> iter = contexts.iterator();
        while (iter.hasNext()) {
            ServerContext lsc = (ServerContext)iter.next();
            ad = lsc.getActionDefinition(action);
            if (ad != null && ad.isEnabled() && ctx.checkPermissions(ad.getPermissions(), this.getCallerController(), lsc, ad)) continue;
            iter.remove();
            RequestIdentifier requestId = new RequestIdentifier("actionNotAvailable" + Math.abs(this.hashCode()));
            String msg = MessageFormat.format(Cres.get().getString("conActNotAvailExt"), action, lsc.toDetailedString());
            ShowMessage message = new ShowMessage(operationName, msg, 2);
            message.setRequestId(requestId);
            message.setBatchEntry(true);
            this.getProcessor().send(message);
        }
        if (contexts.size() == 0) {
            return;
        }
        if (contexts.size() == 1) {
            ServerContext lsc = (ServerContext)contexts.get(0);
            this.redirect(lsc, ad, ActionUtils.createActionInput(executionParameters));
        } else {
            this.redirectToGroupedAction(ctx, contexts, action, this.getCallerController(), ActionUtils.createActionInput(executionParameters).getData());
        }
    }

    @Override
    protected void processError(Throwable ex) {
        if (Util.getRootCause(ex) instanceof DisconnectionException) {
            Log.CONTEXT_ACTIONS.info((Object)("Action interrupted: " + this.toString() + " (caller: " + this.getCallerController() + ")"));
        } else {
            this.getProcessor().showError(Cres.get().getString("error"), 4, ex.getMessage(), ex);
        }
    }
}

