/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.action;

import com.tibbo.aggregate.common.action.ActionIdentifier;
import com.tibbo.aggregate.common.action.GenericActionCommand;
import com.tibbo.aggregate.common.action.GenericActionResponse;
import com.tibbo.aggregate.common.action.RequestIdentifier;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;

public abstract class ProtocolHandler {
    public static final String FIELD_ACTION_RESPONSE_PARAMETERS = "parameters";
    private static final String FIELD_ACTION_RESPONSE_REMEMBER = "remember";
    private static final String FIELD_ACTION_RESPONSE_REQUEST_ID = "requestId";
    private static final String FIELD_ACTION_COMMAND_TYPE = "type";
    private static final String FIELD_ACTION_COMMAND_TITLE = "title";
    private static final String FIELD_ACTION_COMMAND_PARAMETERS = "parameters";
    private static final String FIELD_ACTION_COMMAND_LAST = "last";
    private static final String FIELD_ACTION_COMMAND_BATCH_MEMBER = "batchMember";
    private static final String FIELD_ACTION_COMMAND_REQUEST_ID = "requestId";
    private static final String FIELD_ACTION_ID_ACTION_ID = "actionId";
    private static final TableFormat FORMAT_ACTION_ID_FORMAT = new TableFormat(1, 1, "<actionId><S>");
    private static final TableFormat FORMAT_ACTION_COMMAND = new TableFormat(1, 1);
    private static final TableFormat FORMAT_ACTION_RESPONSE;

    public static DataTable actionIdToDataTable(ActionIdentifier id) {
        String stringId = id != null ? id.toString() : null;
        SimpleDataTable dataTable = new SimpleDataTable(FORMAT_ACTION_ID_FORMAT);
        dataTable.addRecord().addString(stringId);
        return dataTable;
    }

    public static ActionIdentifier actionIdFromDataTable(DataTable table) {
        if (table == null) {
            return null;
        }
        if (!table.getFormat().extend(FORMAT_ACTION_ID_FORMAT)) {
            throw new IllegalArgumentException("Illegal action id table format: " + table.getFormat());
        }
        return new ActionIdentifier(table.rec().getString(FIELD_ACTION_ID_ACTION_ID));
    }

    public static DataTable actionCommandToDataTable(GenericActionCommand cmd) {
        SimpleDataTable table = new SimpleDataTable(FORMAT_ACTION_COMMAND);
        if (cmd == null) {
            return table;
        }
        DataRecord rec = table.addRecord();
        rec.setValue(FIELD_ACTION_COMMAND_TYPE, (Object)cmd.getType());
        rec.setValue(FIELD_ACTION_COMMAND_TITLE, (Object)cmd.getTitle());
        rec.setValue("parameters", (Object)cmd.getParameters());
        rec.setValue(FIELD_ACTION_COMMAND_LAST, (Object)cmd.isLast());
        rec.setValue(FIELD_ACTION_COMMAND_BATCH_MEMBER, (Object)cmd.isBatchEntry());
        rec.setValue("requestId", cmd.getRequestId() != null ? cmd.getRequestId().toString() : null);
        return table;
    }

    public static GenericActionCommand actionCommandFromDataTable(DataTable table) {
        if (table == null) {
            return null;
        }
        if (table.getRecordCount() == 0) {
            return null;
        }
        String type = table.rec().getString(FIELD_ACTION_COMMAND_TYPE);
        GenericActionCommand actionCmd = new GenericActionCommand(type, table.rec().getString(FIELD_ACTION_COMMAND_TITLE));
        actionCmd.setParameters(table.rec().getDataTable("parameters"));
        actionCmd.setLast(table.rec().getBoolean(FIELD_ACTION_COMMAND_LAST));
        actionCmd.setBatchEntry(table.rec().getBoolean(FIELD_ACTION_COMMAND_BATCH_MEMBER));
        String requestIdString = table.rec().getString("requestId");
        actionCmd.setRequestId(requestIdString != null && requestIdString.length() > 0 ? new RequestIdentifier(requestIdString) : null);
        return actionCmd;
    }

    public static DataTable actionResponseToDataTable(GenericActionResponse response) {
        SimpleDataTable table = new SimpleDataTable(FORMAT_ACTION_RESPONSE);
        if (response == null) {
            return table;
        }
        DataRecord rec = table.addRecord();
        rec.setValue("parameters", (Object)response.getParameters());
        rec.setValue(FIELD_ACTION_RESPONSE_REMEMBER, (Object)response.shouldRemember());
        rec.setValue("requestId", response.getRequestId() != null ? response.getRequestId().toString() : null);
        return table;
    }

    public static GenericActionResponse actionResponseFromDataTable(DataTable table) {
        if (table == null || table.getRecordCount() == 0) {
            return new GenericActionResponse(null);
        }
        if (!table.getFormat().extend(FORMAT_ACTION_RESPONSE)) {
            throw new IllegalArgumentException("Illegal action response table format: " + table.getFormat());
        }
        String requestIdString = table.rec().getString("requestId");
        RequestIdentifier requestId = null;
        if (requestIdString != null && requestIdString.length() > 0) {
            requestId = new RequestIdentifier(requestIdString);
        }
        GenericActionResponse actionResp = new GenericActionResponse(table.rec().getDataTable("parameters"), table.rec().getBoolean(FIELD_ACTION_RESPONSE_REMEMBER), requestId);
        return actionResp;
    }

    static {
        FORMAT_ACTION_COMMAND.addField("<type><S>");
        FORMAT_ACTION_COMMAND.addField("<title><S><F=N>");
        FORMAT_ACTION_COMMAND.addField("<parameters><T><F=N>");
        FORMAT_ACTION_COMMAND.addField("<last><B>");
        FORMAT_ACTION_COMMAND.addField("<batchMember><B>");
        FORMAT_ACTION_COMMAND.addField("<requestId><S><F=N>");
        FORMAT_ACTION_RESPONSE = new TableFormat(1, 1);
        FORMAT_ACTION_RESPONSE.addField("<parameters><T><F=N>");
        FORMAT_ACTION_RESPONSE.addField("<remember><B>");
        FORMAT_ACTION_RESPONSE.addField("<requestId><S><F=N>");
    }
}

