/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.action;

import com.tibbo.aggregate.common.action.ActionCommand;
import com.tibbo.aggregate.common.action.ActionCommandRegistry;
import com.tibbo.aggregate.common.action.ActionResponse;
import com.tibbo.aggregate.common.action.GenericActionResponse;
import com.tibbo.aggregate.common.action.RequestIdentifier;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableConversion;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.util.ComponentLocation;

public class GenericActionCommand
implements ActionCommand {
    private String type;
    private DataTable parameters;
    private String title;
    private boolean interactive = true;
    private boolean last;
    private boolean batchEntry;
    private RequestIdentifier requestId;
    private ComponentLocation componentLocation;
    private TableFormat responseFormat;
    public static final String CF_COMPONENT_LOCATION = "componentLocation";

    protected GenericActionCommand(String type, TableFormat requestFormat, TableFormat responseFormat) {
        this.responseFormat = responseFormat;
        this.setType(type);
        this.parameters = new SimpleDataTable(requestFormat);
    }

    protected GenericActionCommand(String type, String title) {
        this.setType(type);
        this.title = title;
    }

    public GenericActionCommand(String type, String title, DataTable parameters, TableFormat format) {
        this(type, title);
        if (parameters == null) {
            return;
        }
        try {
            DataTableConversion.populateBeanFromRecord(this, parameters.rec(), format, true);
        }
        catch (DataTableException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public GenericActionCommand(String type, String title, DataTable parameters) {
        this(type, title);
        this.setParameters(parameters);
        this.setRequestId(new RequestIdentifier(type));
        this.setInteractive(false);
    }

    public void setType(String type) {
        if (type == null || type.length() == 0) {
            throw new IllegalArgumentException("Action command type is null or zero-length");
        }
        this.type = type;
    }

    public GenericActionResponse createDefaultResponse() {
        TableFormat format = this.responseFormat;
        if (format == null) {
            GenericActionCommand command = ActionCommandRegistry.getCommand(this.getType());
            format = command != null ? command.getResponseFormat() : (this.getParameters() != null ? this.getParameters().getFormat() : null);
        }
        SimpleDataTable responseTable = format != null ? new SimpleDataTable(format, true) : null;
        return new GenericActionResponse(responseTable);
    }

    public void setParameters(DataTable parameters) {
        this.parameters = parameters;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    @Override
    public void setBatchEntry(boolean batchEntry) {
        this.batchEntry = batchEntry;
    }

    public void setRequestId(RequestIdentifier requestId) {
        this.requestId = requestId;
    }

    public String getType() {
        return this.type;
    }

    public DataTable getParameters() {
        return this.parameters != null ? this.parameters : this.constructParameters();
    }

    protected DataTable constructParameters() {
        return null;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isLast() {
        return this.last;
    }

    @Override
    public boolean isBatchEntry() {
        return this.batchEntry;
    }

    @Override
    public RequestIdentifier getRequestId() {
        return this.requestId;
    }

    @Override
    public boolean isResponseValid(ActionResponse actionRequest) {
        return true;
    }

    public TableFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    @Override
    public boolean isInteractive() {
        return this.interactive;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.batchEntry ? 1231 : 1237);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.last ? 1231 : 1237);
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.requestId == null ? 0 : this.requestId.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericActionCommand other = (GenericActionCommand)obj;
        if (this.batchEntry != other.batchEntry) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.last != other.last) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        if (this.requestId == null ? other.requestId != null : !this.requestId.equals(other.requestId)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }

    @Override
    public ActionCommand clone() {
        try {
            return (ActionCommand)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public String toString() {
        return "[type=" + this.type + ", title=" + this.title + ", id=" + this.requestId + "]";
    }

    public ComponentLocation getComponentLocation() {
        if (this.componentLocation != null) {
            return this.componentLocation;
        }
        if (this.parameters == null || !this.parameters.hasField(CF_COMPONENT_LOCATION)) {
            return null;
        }
        this.componentLocation = ComponentLocation.fromDataTable(this.parameters.rec().getDataTable(CF_COMPONENT_LOCATION));
        return this.componentLocation;
    }

    public void setComponentLocation(ComponentLocation componentLocation) {
        this.componentLocation = componentLocation;
    }

    public void setComponentLocation(DataTable componentLocation) {
        this.componentLocation = ComponentLocation.fromDataTable(componentLocation);
    }
}

