/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.action;

import com.tibbo.aggregate.common.action.EntityRelatedActionDescriptor;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.util.Util;
import org.apache.commons.lang3.StringUtils;

public class EntityRelatedActions {
    public static final String FIELD_CONTEXT = "context";
    public static final String FIELD_ENTITY = "entity";
    public static final String FIELD_RECORD = "record";
    public static final String FIELD_FIELD = "field";
    public static TableFormat EXECUTION_FORMAT = new TableFormat();

    public static Context getTargetContext(EntityRelatedActionDescriptor ad, Context context, String entity, int entityType, CallerController caller) {
        Context con;
        if (ad.getMask() != null && !ContextUtils.matchesToMask(ad.getMask(), context.getPath())) {
            return null;
        }
        Context context2 = con = ad.getTarget() != null ? context.get(ad.getTarget(), caller) : context;
        if (con == null) {
            return null;
        }
        return EntityRelatedActions.allowedContextOrNull(entity, entityType, ad.getEntity(), con);
    }

    protected static Context allowedContextOrNull(String entity, int entityType, String allowedEntities, Context con) {
        String[] allowedEntitiesArray;
        if (allowedEntities == null) {
            return con;
        }
        for (String allowedEntity : allowedEntitiesArray = StringUtils.split((String)allowedEntities, (String)" ")) {
            String entityBaseGroup;
            String allowedGroup = ContextUtils.getGroupName(allowedEntity = StringUtils.trim((String)allowedEntity));
            if (!(allowedGroup == null ? Util.equals(allowedEntity, entity) : Util.equals(allowedGroup, entityBaseGroup = ContextUtils.getBaseGroup(EntityRelatedActions.entityGroup(entity, entityType, con))))) continue;
            return con;
        }
        return null;
    }

    private static String entityGroup(String entity, int entityType, Context con) {
        if (con == null) {
            return null;
        }
        switch (entityType) {
            case 1: {
                if (con.getVariableDefinition(entity) == null) {
                    return null;
                }
                return con.getVariableDefinition(entity).getGroup();
            }
            case 2: {
                if (con.getFunctionDefinition(entity) == null) {
                    return null;
                }
                return con.getFunctionDefinition(entity).getGroup();
            }
            case 4: {
                if (con.getEventDefinition(entity) == null) {
                    return null;
                }
                return con.getEventDefinition(entity).getGroup();
            }
        }
        throw new IllegalStateException("Unknown entity type: " + entityType);
    }

    static {
        EXECUTION_FORMAT.addField("<context><S>");
        EXECUTION_FORMAT.addField("<entity><S>");
        EXECUTION_FORMAT.addField("<record><T><F=N>");
        EXECUTION_FORMAT.addField("<field><S><F=N>");
    }
}

