/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.action;

import com.tibbo.aggregate.common.action.BatchEntry;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class BatchContext {
    private List<BatchEntry> entries = new LinkedList<BatchEntry>();
    private BatchEntry currentEntry;

    void addBatchEntry(BatchEntry batchEntry) {
        if (batchEntry == null) {
            throw new NullPointerException();
        }
        this.entries.add(batchEntry);
    }

    public List<BatchEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public BatchEntry getCurrentEntry() {
        return this.currentEntry;
    }

    public void markAsPerfomed(BatchEntry entry) {
        if (!this.entries.contains(entry)) {
            throw new IllegalArgumentException("Entry '" + entry + "' is not on the list");
        }
        entry.setFulfilled(true);
    }

    protected void setCurrentEntry(BatchEntry currentEntry) {
        this.currentEntry = currentEntry;
    }
}

