/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.action;

import com.tibbo.aggregate.common.action.Action;
import com.tibbo.aggregate.common.action.ActionCommand;
import com.tibbo.aggregate.common.action.ActionContext;
import com.tibbo.aggregate.common.action.ActionExecutionMode;
import com.tibbo.aggregate.common.action.ActionIdentifier;
import com.tibbo.aggregate.common.action.ActionManager;
import com.tibbo.aggregate.common.action.ActionResponse;
import com.tibbo.aggregate.common.action.ActionResult;
import com.tibbo.aggregate.common.action.BatchContext;
import com.tibbo.aggregate.common.action.BatchEntry;
import com.tibbo.aggregate.common.action.InitialRequest;
import java.util.Optional;

class BatchAction
implements Action {
    private ActionManager actionManager;
    private ActionContext actionContext;
    private ActionIdentifier currentActionId;

    public BatchAction(ActionManager actionManager) {
        if (actionManager == null) {
            throw new NullPointerException();
        }
        this.actionManager = actionManager;
    }

    public synchronized void init(ActionContext actionContext, InitialRequest initialParameters) {
        if (actionContext == null) {
            throw new NullPointerException();
        }
        this.actionContext = actionContext;
    }

    public synchronized ActionCommand service(ActionResponse actionRequest) {
        BatchContext batchContext = this.actionContext.getBatchContext();
        if (batchContext == null) {
            throw new AssertionError();
        }
        while (true) {
            ActionCommand actionCommand;
            if (this.currentActionId == null) {
                BatchEntry batchEntry = this.getNextEntry(batchContext);
                if (batchEntry == null) {
                    return null;
                }
                ActionContext entryContext = batchEntry.getActionContext();
                entryContext.getRequestedIds().clear();
                this.currentActionId = this.actionManager.initAction(entryContext, batchEntry.getInitialRequest(), new ActionExecutionMode(2), null);
                actionCommand = this.actionManager.service(this.currentActionId, null);
            } else {
                actionCommand = this.actionManager.service(this.currentActionId, actionRequest);
            }
            if (actionCommand != null) {
                actionCommand.setBatchEntry(true);
                return actionCommand;
            }
            this.currentActionId = null;
            batchContext.markAsPerfomed(batchContext.getCurrentEntry());
        }
    }

    private BatchEntry getNextEntry(BatchContext batchContext) throws IllegalArgumentException {
        Optional<BatchEntry> entry = batchContext.getEntries().stream().filter(e -> !e.isFulfilled()).findFirst();
        if (entry.isPresent()) {
            BatchEntry currentEntry = entry.get();
            batchContext.setCurrentEntry(currentEntry);
            return currentEntry;
        }
        return null;
    }

    @Override
    public synchronized ActionResult destroy() {
        if (this.currentActionId != null) {
            this.actionManager.destroyAction(this.currentActionId);
        }
        this.actionManager = null;
        this.actionContext = null;
        this.currentActionId = null;
        return null;
    }
}

