/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.action;

import com.tibbo.aggregate.common.action.Action;
import com.tibbo.aggregate.common.action.ActionCommand;
import com.tibbo.aggregate.common.action.ActionCommandList;
import com.tibbo.aggregate.common.action.ActionDefinition;
import com.tibbo.aggregate.common.action.GroupIdentifier;
import com.tibbo.aggregate.common.action.KeyStroke;
import com.tibbo.aggregate.common.action.ResourceMask;
import com.tibbo.aggregate.common.context.AbstractEntityDefinition;
import com.tibbo.aggregate.common.security.Permissions;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class BasicActionDefinition
extends AbstractEntityDefinition
implements ActionDefinition,
ActionCommandList {
    private static final String GROUP_ID_SEPARATOR = "/";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_DESCRIPTION = "description";
    private static final String PROPERTY_DROP_SOURCES = "dropSources";
    private static final String PROPERTY_HELP = "help";
    private static final String PROPERTY_ACCELERATOR = "accelerator";
    private static final String PROPERTY_HIDDEN = "hidden";
    private static final String PROPERTY_ENABLED = "enabled";
    private static final String PROPERTY_GROUP_ID = "groupId";
    private static final String PROPERTY_ICON_ID = "iconId";
    private static final String PROPERTY_DEFAULT = "default";
    private transient PropertyChangeSupport propertyChangeListeners = new PropertyChangeSupport(this);
    private final Class actionClass;
    private boolean enabled = true;
    private boolean isDefault;
    private boolean hidden;
    private GroupIdentifier executionGroup;
    private KeyStroke accelerator;
    private List<ResourceMask> dropSources;
    private List<ActionCommand> commandList;
    public boolean concurrent = true;
    private Permissions permissions;
    private final ReentrantLock executionLock = new ReentrantLock();

    public BasicActionDefinition(String name) {
        this(name, null);
    }

    public BasicActionDefinition(String name, Class actionClass) {
        if (actionClass != null && !Action.class.isAssignableFrom(actionClass)) {
            throw new IllegalArgumentException("Action class should implement Action interface");
        }
        super.setName(name);
        this.actionClass = actionClass;
    }

    @Override
    public GroupIdentifier getExecutionGroup() {
        return this.executionGroup;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public KeyStroke getAccelerator() {
        return this.accelerator;
    }

    @Override
    public List<ResourceMask> getDropSources() {
        if (this.dropSources != null) {
            return Collections.unmodifiableList(this.dropSources);
        }
        return null;
    }

    @Override
    public void setIconId(String iconId) {
        String oldIconId = this.getIconId();
        super.setIconId(iconId);
        this.propertyChangeListeners.firePropertyChange(PROPERTY_ICON_ID, oldIconId, iconId);
    }

    @Override
    public void setHelp(String help) {
        String oldHelp = this.getHelp();
        super.setHelp(help);
        this.propertyChangeListeners.firePropertyChange(PROPERTY_HELP, oldHelp, help);
    }

    @Override
    public void setDescription(String description) {
        String oldDescription = this.getDescription();
        super.setDescription(description);
        this.propertyChangeListeners.firePropertyChange(PROPERTY_DESCRIPTION, oldDescription, description);
    }

    public void setExecutionGroup(String base) {
        this.setExecutionGroup(new GroupIdentifier(this.getName() + GROUP_ID_SEPARATOR + base));
    }

    public void setExecutionGroup(GroupIdentifier groupId) {
        GroupIdentifier oldGroupId = this.executionGroup;
        this.executionGroup = groupId;
        this.propertyChangeListeners.firePropertyChange(PROPERTY_GROUP_ID, oldGroupId, groupId);
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.enabled;
        this.enabled = enabled;
        this.propertyChangeListeners.firePropertyChange(PROPERTY_ENABLED, (Object)oldEnabled, (Object)enabled);
    }

    public void setHidden(boolean hidden) {
        boolean oldHidden = this.hidden;
        this.hidden = hidden;
        this.propertyChangeListeners.firePropertyChange(PROPERTY_HIDDEN, (Object)oldHidden, (Object)hidden);
    }

    public void setAccelerator(KeyStroke accelerator) {
        KeyStroke oldAccelerator = this.accelerator;
        this.accelerator = accelerator;
        this.propertyChangeListeners.firePropertyChange(PROPERTY_ACCELERATOR, oldAccelerator, accelerator);
    }

    public void setDropSources(List<ResourceMask> dropSources) {
        if (dropSources == null) {
            throw new NullPointerException();
        }
        for (ResourceMask resourceMask : dropSources) {
            if (resourceMask != null) continue;
            throw new NullPointerException();
        }
        List<ResourceMask> oldDropSources = this.dropSources;
        this.dropSources = dropSources;
        this.propertyChangeListeners.firePropertyChange(PROPERTY_DROP_SOURCES, oldDropSources, dropSources);
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.propertyChangeListeners.firePropertyChange(PROPERTY_NAME, oldName, name);
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public void setDefault(boolean isDefault) {
        boolean oldIsDefault = this.isDefault;
        this.isDefault = isDefault;
        this.propertyChangeListeners.firePropertyChange(PROPERTY_DEFAULT, oldIsDefault, isDefault);
    }

    @Override
    public boolean isConcurrent() {
        return this.concurrent;
    }

    public void setConcurrent(boolean allowConcurrentExecution) {
        this.concurrent = allowConcurrentExecution;
    }

    public void addDropSource(ResourceMask resourceMask) {
        if (resourceMask == null) {
            throw new NullPointerException();
        }
        this.dropSources.add(resourceMask);
    }

    @Override
    public Action instantiate() {
        if (this.actionClass == null) {
            throw new IllegalArgumentException("Redirection to actions of proxy contexts is not supported");
        }
        Action action = null;
        try {
            action = (Action)this.actionClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return action;
    }

    @Override
    public List<ActionCommand> getCommands() {
        if (this.commandList == null) {
            this.commandList = new LinkedList<ActionCommand>();
            this.registerCommands();
        }
        return Collections.unmodifiableList(this.commandList);
    }

    protected void registerCommands() {
    }

    protected synchronized void registerCommand(ActionCommand cmd) {
        if (cmd == null) {
            throw new NullPointerException("cmd is null");
        }
        if ((cmd = cmd.clone()).getRequestId() == null) {
            throw new IllegalArgumentException("Request ID is NULL");
        }
        if (this.commandList == null) {
            this.commandList = new LinkedList<ActionCommand>();
        }
        for (ActionCommand listCommand : this.commandList) {
            if (!cmd.getRequestId().equals(listCommand.getRequestId())) continue;
            if (cmd.equals(listCommand)) {
                return;
            }
            throw new IllegalArgumentException("Command has already been registered: " + cmd.getRequestId());
        }
        this.commandList.add(cmd);
    }

    protected synchronized void unregisterCommand(String id) {
        if (this.commandList == null) {
            return;
        }
        Iterator<ActionCommand> iterator = this.commandList.iterator();
        while (iterator.hasNext()) {
            ActionCommand listCommand = iterator.next();
            if (!id.equals(listCommand.getRequestId())) continue;
            iterator.remove();
        }
    }

    @Override
    public ReentrantLock getExecutionLock() {
        return this.executionLock;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeListeners.removePropertyChangeListener(l);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeListeners.addPropertyChangeListener(l);
    }

    @Override
    public boolean isHeadless() {
        return false;
    }

    @Override
    public Permissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    public int compareTo(Object o) {
        return 0;
    }

    @Override
    public Integer getEntityType() {
        return 8;
    }
}

