/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.action;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.action.Action;
import com.tibbo.aggregate.common.action.ActionCommand;
import com.tibbo.aggregate.common.action.ActionContext;
import com.tibbo.aggregate.common.action.ActionDefinition;
import com.tibbo.aggregate.common.action.ActionDirectory;
import com.tibbo.aggregate.common.action.ActionExecutionMode;
import com.tibbo.aggregate.common.action.ActionIdGenerator;
import com.tibbo.aggregate.common.action.ActionIdentifier;
import com.tibbo.aggregate.common.action.ActionLocator;
import com.tibbo.aggregate.common.action.ActionResponse;
import com.tibbo.aggregate.common.action.ActionResult;
import com.tibbo.aggregate.common.action.BatchAction;
import com.tibbo.aggregate.common.action.BatchContext;
import com.tibbo.aggregate.common.action.BatchEntry;
import com.tibbo.aggregate.common.action.InitialRequest;
import com.tibbo.aggregate.common.action.RequestCache;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.datatable.DataTable;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class ActionManager {
    private final ActionDirectory actionDirectory;
    private final ActionIdGenerator actionIdGenerator = new ActionIdGenerator();
    private final Map<ActionIdentifier, Action> actions = Collections.synchronizedMap(new HashMap());
    private final Map<Action, ActionIdentifier> actionIDs = Collections.synchronizedMap(new HashMap());
    private final Map<Action, ActionContext> actionContexts = Collections.synchronizedMap(new HashMap());

    public ActionManager(ActionDirectory actionDirectory) {
        if (actionDirectory == null) {
            throw new NullPointerException();
        }
        this.actionDirectory = actionDirectory;
    }

    public List<ActionDefinition> resolveDefinitions(List<ActionLocator> actionLocators) {
        if (actionLocators == null) {
            throw new NullPointerException();
        }
        LinkedList<ActionDefinition> actionDefinitions = new LinkedList<ActionDefinition>();
        for (ActionLocator actionLocator : actionLocators) {
            ActionDefinition actionDefinition = this.actionDirectory.getActionDefinition(actionLocator);
            if (actionDefinition == null) {
                throw new IllegalArgumentException("Can't resolve: " + actionLocator);
            }
            actionDefinitions.add(actionDefinition);
        }
        return actionDefinitions;
    }

    public ActionIdentifier initActions(List<BatchEntry> entries, ActionContext batchActionContext) {
        if (entries == null) {
            throw new NullPointerException();
        }
        if (batchActionContext == null) {
            throw new NullPointerException();
        }
        RequestCache requestCache = new RequestCache();
        BatchContext batchContext = new BatchContext();
        for (BatchEntry entry : entries) {
            if (entry == null) {
                throw new IllegalArgumentException("Entries list contains nulls");
            }
            ActionContext actionContext = entry.getActionContext();
            actionContext.setBatchContext(batchContext);
            actionContext.setRequestCache(requestCache);
            batchContext.addBatchEntry(entry);
        }
        batchActionContext.setBatchContext(batchContext);
        batchActionContext.setRequestCache(requestCache);
        BatchAction batchAction = new BatchAction(this);
        batchAction.init(batchActionContext, null);
        batchActionContext.setActionState(ActionContext.ActionState.INITIALIZED);
        return this.registerAction(batchActionContext, batchAction, new ActionExecutionMode(2), null);
    }

    public ActionIdentifier initAction(ActionContext actionContext, InitialRequest initialParameters, ActionExecutionMode mode, String customActionId) {
        ActionDefinition actionDefinition = actionContext.getActionDefinition();
        ReentrantLock lock = actionDefinition.getExecutionLock();
        if (lock.isLocked() && !lock.isHeldByCurrentThread()) {
            String owner = "";
            try {
                DataTable lockedBy = actionContext.getDefiningContext().callFunction("lockedBy", actionContext.getCallerController());
                if (lockedBy != null && lockedBy.getRecordCount() > 0) {
                    owner = lockedBy.rec().getString("lockOwnerName");
                }
            }
            catch (ContextException ex) {
                Log.CONTEXT_ACTIONS.debug((Object)("Couldn't get lock's owner for action '" + actionDefinition.getName() + "' of context '" + actionContext.getDefiningContext() + "'"), (Throwable)ex);
            }
            throw new IllegalStateException(MessageFormat.format(Cres.get().getString("acActionBeingExecuted"), owner));
        }
        Action action = this.instantiateAction(actionDefinition);
        actionContext.setActionState(ActionContext.ActionState.CREATED);
        action.init(actionContext, initialParameters);
        actionContext.setActionState(ActionContext.ActionState.INITIALIZED);
        return this.registerAction(actionContext, action, mode, customActionId);
    }

    protected Action instantiateAction(ActionDefinition actionDefinition) {
        if (actionDefinition == null) {
            throw new NullPointerException();
        }
        return actionDefinition.instantiate();
    }

    public ActionCommand service(ActionIdentifier actionId, ActionResponse actionRequest) {
        if (actionId == null) {
            throw new NullPointerException();
        }
        Action action = this.actions.get(actionId);
        if (action == null) {
            throw new IllegalStateException("Action with id '" + actionId + "' doesn't exists");
        }
        ActionContext actionContext = this.actionContexts.get(action);
        if (actionRequest == null && actionContext.getActionState() != ActionContext.ActionState.INITIALIZED) {
            throw new IllegalArgumentException("Null actionRequest is allowed only within first call to service()");
        }
        actionContext.setActionState(ActionContext.ActionState.WORKING);
        ActionCommand actionCommand = null;
        ActionResponse activeRequest = actionRequest;
        do {
            RequestCache requestCache = actionContext.getRequestCache();
            if (activeRequest != null && activeRequest.getRequestId() != null && activeRequest.shouldRemember()) {
                if (requestCache == null) {
                    requestCache = new RequestCache();
                    actionContext.setRequestCache(requestCache);
                }
                requestCache.addRequest(activeRequest.getRequestId(), activeRequest);
            }
            actionCommand = (ActionCommand)action.service(activeRequest);
            activeRequest = requestCache != null && actionCommand != null && actionCommand.getRequestId() != null && !actionContext.getRequestedIds().contains(actionCommand.getRequestId()) ? requestCache.getRequest(actionCommand.getRequestId()) : null;
            if (actionCommand == null || actionCommand.getRequestId() == null) continue;
            actionContext.getRequestedIds().add(actionCommand.getRequestId());
        } while (activeRequest != null);
        return actionCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionResult destroyAction(ActionIdentifier actionId) {
        if (actionId == null) {
            throw new NullPointerException();
        }
        Action action = this.actions.get(actionId);
        if (action == null) {
            Log.CONTEXT_ACTIONS.debug((Object)("Action with id '" + actionId + "' doesn't exists"));
            return null;
        }
        try {
            this.actionContexts.get(action).setActionState(ActionContext.ActionState.DESTROYED);
            ActionResult actionResult = action.destroy();
            return actionResult;
        }
        finally {
            this.actions.remove(actionId);
            this.actionIDs.remove(action);
            this.actionContexts.remove(action);
        }
    }

    public void destroyAll() {
        for (ActionIdentifier actionId : new LinkedHashSet<ActionIdentifier>(this.actions.keySet())) {
            this.destroyAction(actionId);
        }
    }

    public ActionContext getActionContext(ActionIdentifier actionId) {
        Action action = this.actions.get(actionId);
        return this.actionContexts.get(action);
    }

    public ActionIdentifier getActionID(Action action) {
        return this.actionIDs.get(action);
    }

    public Action getAction(ActionIdentifier actionID) {
        return this.actions.get(actionID);
    }

    public ActionDirectory getActionDirectory() {
        return this.actionDirectory;
    }

    protected ActionIdentifier registerAction(ActionContext actionContext, Action action, ActionExecutionMode mode, String customActionId) {
        ActionIdentifier actionId = customActionId == null ? this.actionIdGenerator.generate(action) : new ActionIdentifier(customActionId);
        actionContext.setActionExecutionMode(mode);
        if (this.actions.containsKey(actionId)) {
            throw new IllegalArgumentException("Action: " + actionId.getId() + " is already existed.");
        }
        this.actions.put(actionId, action);
        this.actionIDs.put(action, actionId);
        this.actionContexts.put(action, actionContext);
        return actionId;
    }
}

