/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.action;

import com.tibbo.aggregate.common.action.ActionDefinition;
import com.tibbo.aggregate.common.action.ActionExecutionMode;
import com.tibbo.aggregate.common.action.ActionManager;
import com.tibbo.aggregate.common.action.BatchContext;
import com.tibbo.aggregate.common.action.RequestCache;
import com.tibbo.aggregate.common.action.RequestIdentifier;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class ActionContext {
    private ActionDefinition actionDefinition;
    private BatchContext batchContext;
    private RequestCache requestCache;
    private ActionState actionState = ActionState.CREATED;
    private ActionManager actionManager;
    private final Set<RequestIdentifier> requestedIds = new LinkedHashSet<RequestIdentifier>();
    private ActionExecutionMode actionExecutionMode;
    private ChangeActionStateListener changeActionStateListener = null;
    private boolean executedAsDefault;

    public ActionContext(ActionDefinition actionDefinition, ActionManager actionManager) {
        this.setActionDefinition(actionDefinition);
        this.setActionManager(actionManager);
    }

    public abstract CallerController getCallerController();

    public abstract Context getDefiningContext();

    public ActionDefinition getActionDefinition() {
        return this.actionDefinition;
    }

    public BatchContext getBatchContext() {
        return this.batchContext;
    }

    public RequestCache getRequestCache() {
        return this.requestCache;
    }

    public ActionState getActionState() {
        return this.actionState;
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    Set<RequestIdentifier> getRequestedIds() {
        return this.requestedIds;
    }

    void setActionDefinition(ActionDefinition actionDefinition) {
        if (actionDefinition == null) {
            throw new NullPointerException();
        }
        this.actionDefinition = actionDefinition;
    }

    public void setBatchContext(BatchContext batchContext) {
        this.batchContext = batchContext;
    }

    public void setRequestCache(RequestCache requestCache) {
        this.requestCache = requestCache;
    }

    void setActionState(ActionState actionState) {
        if (actionState == null) {
            throw new NullPointerException();
        }
        ActionState old = this.actionState;
        this.actionState = actionState;
        if (this.changeActionStateListener != null && old != actionState) {
            this.changeActionStateListener.changeActionState(old, actionState);
        }
    }

    void setActionManager(ActionManager actionManager) {
        if (actionManager == null) {
            throw new NullPointerException();
        }
        this.actionManager = actionManager;
    }

    public void setChangeActionStateListener(ChangeActionStateListener changeActionStateListener) {
        this.changeActionStateListener = changeActionStateListener;
    }

    public ActionExecutionMode getActionExecutionMode() {
        return this.actionExecutionMode;
    }

    public void setActionExecutionMode(ActionExecutionMode actionExecutionMode) {
        this.actionExecutionMode = actionExecutionMode;
    }

    public boolean isExecutedAsDefault() {
        return this.executedAsDefault;
    }

    public void setExecutedAsDefault(boolean executedAsDefault) {
        this.executedAsDefault = executedAsDefault;
    }

    public static enum ActionState {
        CREATED,
        INITIALIZED,
        WORKING,
        DESTROYED;

    }

    public static interface ChangeActionStateListener {
        public void changeActionState(ActionState var1, ActionState var2);
    }
}

