/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.action;

import com.tibbo.aggregate.common.action.GenericActionCommand;
import com.tibbo.aggregate.common.action.command.ActivateDashboard;
import com.tibbo.aggregate.common.action.command.Browse;
import com.tibbo.aggregate.common.action.command.CloseDashboard;
import com.tibbo.aggregate.common.action.command.Confirm;
import com.tibbo.aggregate.common.action.command.EditCode;
import com.tibbo.aggregate.common.action.command.EditData;
import com.tibbo.aggregate.common.action.command.EditExpression;
import com.tibbo.aggregate.common.action.command.EditGridDashboard;
import com.tibbo.aggregate.common.action.command.EditProperties;
import com.tibbo.aggregate.common.action.command.EditReport;
import com.tibbo.aggregate.common.action.command.EditTemplate;
import com.tibbo.aggregate.common.action.command.EditText;
import com.tibbo.aggregate.common.action.command.LaunchProcessControlProgram;
import com.tibbo.aggregate.common.action.command.LaunchWidget;
import com.tibbo.aggregate.common.action.command.OpenGridDashboard;
import com.tibbo.aggregate.common.action.command.SelectEntities;
import com.tibbo.aggregate.common.action.command.ShowDiff;
import com.tibbo.aggregate.common.action.command.ShowError;
import com.tibbo.aggregate.common.action.command.ShowEventLog;
import com.tibbo.aggregate.common.action.command.ShowGuide;
import com.tibbo.aggregate.common.action.command.ShowHtmlSnippet;
import com.tibbo.aggregate.common.action.command.ShowMessage;
import com.tibbo.aggregate.common.action.command.ShowReport;
import com.tibbo.aggregate.common.action.command.ShowSystemTree;
import java.util.HashMap;
import java.util.Map;

public class ActionCommandRegistry {
    private static Map<String, GenericActionCommand> COMMANDS = new HashMap<String, GenericActionCommand>();

    public static GenericActionCommand getCommand(String type) {
        return COMMANDS.get(type);
    }

    private static void register(GenericActionCommand command) {
        COMMANDS.put(command.getType(), command);
    }

    static {
        ActionCommandRegistry.register(new ActivateDashboard());
        ActionCommandRegistry.register(new Browse());
        ActionCommandRegistry.register(new Confirm());
        ActionCommandRegistry.register(new EditCode());
        ActionCommandRegistry.register(new EditData());
        ActionCommandRegistry.register(new EditProperties());
        ActionCommandRegistry.register(new EditReport());
        ActionCommandRegistry.register(new EditText());
        ActionCommandRegistry.register(new EditTemplate("editWidget"));
        ActionCommandRegistry.register(new LaunchWidget());
        ActionCommandRegistry.register(new EditTemplate("editProcessControlProgram"));
        ActionCommandRegistry.register(new LaunchProcessControlProgram());
        ActionCommandRegistry.register(new EditTemplate("editWorkflow"));
        ActionCommandRegistry.register(new SelectEntities());
        ActionCommandRegistry.register(new ShowDiff());
        ActionCommandRegistry.register(new ShowError());
        ActionCommandRegistry.register(new ShowEventLog());
        ActionCommandRegistry.register(new ShowGuide());
        ActionCommandRegistry.register(new ShowMessage());
        ActionCommandRegistry.register(new ShowReport());
        ActionCommandRegistry.register(new ShowHtmlSnippet());
        ActionCommandRegistry.register(new ShowSystemTree());
        ActionCommandRegistry.register(new CloseDashboard());
        ActionCommandRegistry.register(new OpenGridDashboard());
        ActionCommandRegistry.register(new EditGridDashboard());
        ActionCommandRegistry.register(new EditExpression());
    }
}

