/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common;

import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.expression.EvaluationEnvironment;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import java.util.HashMap;
import java.util.Map;

public class VariableValidator {
    private final Map<String, String> expressionByMask = new HashMap<String, String>();

    public void addExpressionByMask(String mask, String expression) {
        this.expressionByMask.put(mask, expression);
    }

    public String getExpressionForContext(String path) {
        for (String mask : this.expressionByMask.keySet()) {
            if (ContextUtils.matchesToMask(mask, path)) continue;
            return this.expressionByMask.get(mask);
        }
        return null;
    }

    public Object validate(Context context, ContextManager contextManager, DataTable value) throws ContextException {
        String expression = this.getExpressionForContext(context.getPath());
        if (expression == null) {
            return null;
        }
        Evaluator evaluator = new Evaluator(contextManager, contextManager.getCallerController(), true);
        evaluator.setDefaultContext(context);
        evaluator.setDefaultTable(value);
        try {
            return evaluator.evaluate(new Expression(expression), new EvaluationEnvironment());
        }
        catch (EvaluationException | SyntaxErrorException e) {
            throw new ContextException(e);
        }
    }
}

