/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common;

import com.tibbo.aggregate.common.util.JarVersion;
import java.io.File;
import java.util.Arrays;

public class SoftwareVersion {
    public static String[] SYSTEM_CLASS_PATH = System.getProperty("java.class.path").split(File.pathSeparator);
    private static String currentVersion = "6.34.06";
    private static String currentBuild = "SNAPSHOT";
    private static String currentRevision = "";

    public static void initVersion(String targetClassPath) {
        JarVersion.getClassPathJarVersionsByTarget(Arrays.asList(SYSTEM_CLASS_PATH), targetClassPath).ifPresent(jarVersion -> {
            if (jarVersion.implementationVersion != null) {
                currentVersion = jarVersion.implementationVersion;
            }
            if (jarVersion.buildNumber != null) {
                currentBuild = jarVersion.buildNumber;
            }
            if (jarVersion.revisionNumber != null) {
                currentRevision = jarVersion.revisionNumber;
            }
        });
    }

    public static String getCurrentVersion() {
        return currentVersion;
    }

    public static String getCurrentBuild() {
        return currentBuild;
    }

    public static String getCurrentVersionAndBuild() {
        return currentVersion + "-" + currentBuild;
    }

    public static String getCurrentRevision() {
        return currentRevision;
    }
}

