/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.event.ContextEventListener;

public class AlertsSubscriber
implements Runnable {
    private ContextEventListener listener;
    private ContextManager manager;
    private CallerController controller;
    private String username;

    public AlertsSubscriber(ContextEventListener listener, ContextManager manager, CallerController controller, String username) {
        this.username = username;
        this.listener = listener;
        this.manager = manager;
        this.controller = controller;
    }

    public void subscribe() {
        this.run();
    }

    @Override
    public void run() {
        try {
            String mask;
            int popupMode = 0;
            Object userContext = this.manager.get(ContextUtils.userContextPath(this.username), this.controller);
            if (userContext != null && userContext.getVariableDefinition("alertsConfig", this.controller) != null) {
                DataTable alertsConfig = userContext.getVariable("alertsConfig", this.controller);
                popupMode = alertsConfig.rec().getInt("mode");
            }
            switch (popupMode) {
                case 0: {
                    mask = ContextUtils.alertContextPath(this.username, "*");
                    break;
                }
                case 1: {
                    mask = ContextUtils.alertContextPath("*", "*");
                    break;
                }
                case 2: {
                    return;
                }
                default: {
                    throw new IllegalStateException("Unknown alert popup mode: " + popupMode);
                }
            }
            this.manager.addMaskEventListener(mask, "alertnotify", this.listener);
        }
        catch (Exception ex) {
            Log.CLIENTS.error((Object)("Error subscribing to alert notifications for " + this.username), (Throwable)ex);
        }
    }
}

