/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.client.guibuilder.renderers;

import com.tibbo.aggregate.client.guibuilder.AggreGateIDE;
import com.tibbo.aggregate.client.guibuilder.CustomTransferHandler;
import com.tibbo.aggregate.client.guibuilder.editableComponent.EditableComponent;
import com.tibbo.aggregate.client.guibuilder.renderers.PanelWithPaintHelper;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.binding.Binding;
import com.tibbo.aggregate.common.binding.EvaluationOptions;
import com.tibbo.aggregate.common.binding.ExtendedBinding;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import com.tibbo.aggregate.common.widget.WBindingUtils;
import com.tibbo.aggregate.common.widget.WGridConstraints;
import com.tibbo.aggregate.common.widget.WidgetApiUtils;
import com.tibbo.aggregate.common.widget.WidgetConstants;
import com.tibbo.aggregate.common.widget.component.WAbstractComponent;
import com.tibbo.aggregate.common.widget.component.WComponent;
import com.tibbo.aggregate.common.widget.component.WContainer;
import com.tibbo.aggregate.common.widget.context.WAbstractContext;
import com.tibbo.aggregate.common.widget.context.WComponentContext;
import com.tibbo.aggregate.common.widget.context.WContainerContext;
import com.tibbo.aggregate.common.widget.runtime.renderers.AbstractSwingRenderer;
import com.tibbo.aggregate.common.widget.runtime.renderers.SwingRendererSupport;
import com.tibbo.aggregate.common.widget.runtime.renderers.WidgetComponentRenderer;
import com.tibbo.aggregate.common.widget.runtime.util.WidgetComponentApiRendererUtilities;
import com.tibbo.aggregate.component.entityselector.EntityNode;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public abstract class EditorRendererSupport<C extends WAbstractComponent, T extends WAbstractContext<WComponentContext, C>, O extends JComponent, U extends EditableComponent>
extends SwingRendererSupport<C, T, O> {
    private U editableComponent;
    private GridBagConstraints constraints;
    private JPanel panelWithHelper;

    public EditorRendererSupport(AbstractSwingRenderer<C, T, O, SwingRendererSupport> renderer) {
        super(renderer);
    }

    public void addEditorModeDecorations() {
        if (!this.getRenderer().getComponentContext().getName().equals("")) {
            this.getProduction().setBorder(BorderFactory.createEtchedBorder());
        }
        Border b = this.getEditableComponent().getEditorModeBorder();
        if (!WidgetComponentApiRendererUtilities.hasCustomBorder((WComponent)this.getRenderer().getComponentContext().getComponent()) && b != null) {
            this.getEditableComponent().setBorder(b);
        }
        this.initView();
    }

    public void removeEditorModeDecorations() {
        if (!this.getRenderer().getComponentContext().getName().equals("")) {
            this.getProduction().setBorder(null);
        }
        Border b = this.getEditableComponent().getEditorModeBorder();
        if (!WidgetComponentApiRendererUtilities.hasCustomBorder((WComponent)this.getRenderer().getComponentContext().getComponent()) && b != null) {
            this.getEditableComponent().setBorder(null);
        }
        this.getProduction().revalidate();
    }

    public U getEditableComponent() {
        return this.editableComponent;
    }

    protected abstract U createEditableComponent();

    public void recreateEditableComponent() {
        boolean reset;
        boolean bl = reset = this.editableComponent != null && this.getGuiBuilder().getWorkPane().getSelectedNodes().contains(this.getRenderer().getComponentContext());
        if (this.editableComponent != null) {
            this.editableComponent.removeMouseListener((MouseListener)this.getGuiBuilder().getWorkPane().getSizeInsetsEditingListener());
            this.editableComponent.removeMouseMotionListener((MouseMotionListener)this.getGuiBuilder().getWorkPane().getSizeInsetsEditingListener());
            this.editableComponent.stop();
        }
        this.editableComponent = this.createEditableComponent();
        this.initView();
        if (this.getGuiBuilder().getViewer() != null && this.getGuiBuilder().getViewer().isDecoratedMode() && this.getGuiBuilder().getDataModel().getResourceByID(this.getRenderer().getComponentContext().getName()) != null) {
            this.addEditorModeDecorations();
        }
        this.getEditableComponent().addMouseListener((MouseListener)this.getGuiBuilder().getWorkPane().getSizeInsetsEditingListener());
        this.getEditableComponent().addMouseMotionListener((MouseMotionListener)this.getGuiBuilder().getWorkPane().getSizeInsetsEditingListener());
        if (reset) {
            this.getGuiBuilder().getWorkPane().repaint();
        }
    }

    public AggreGateIDE getGuiBuilder() {
        return (AggreGateIDE)((Object)this.getRenderer().getEngine());
    }

    protected PanelWithPaintHelper createPanelWithHelper() {
        return new PanelWithPaintHelper();
    }

    @Override
    public void initView() {
        if (this.panelWithHelper == null) {
            this.panelWithHelper = this.createPanelWithHelper();
        }
        this.panelWithHelper.setLayout(new GridBagLayout());
        this.panelWithHelper.setOpaque(false);
        if (this.constraints == null) {
            this.constraints = new GridBagConstraints();
        }
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        if (this.getEditableComponent() == null) {
            this.recreateEditableComponent();
        }
        this.reinitConstraints();
        Object component = this.getRenderer().getComponent();
        Object render = this.getRenderer().getRender();
        WidgetComponentApiRendererUtilities.initBasicProperties((WAbstractContext)this.getRenderer().getComponentContext(), component, (JComponent)render, this.getRenderer().getEngine().getServerContextManager());
        WidgetComponentApiRendererUtilities.setRendererSize((JComponent)render, component);
        this.getEditableComponent().reviewRender();
        this.getEditableComponent().setToolTipText(this.getRenderer().getComponentContext().getName() + " (" + ((WComponent)component).getDescription() + ")");
    }

    public void reinitConstraints() {
        Component editableComponent;
        if (!this.getRenderer().getComponentContext().getName().equals("")) {
            this.refreshInternalConstraints();
        }
        if ((editableComponent = (Component)this.getEditableComponent()).getParent() != this.panelWithHelper) {
            this.panelWithHelper.removeAll();
            this.panelWithHelper.add(editableComponent, this.constraints);
        } else {
            GridBagLayout layout = (GridBagLayout)this.panelWithHelper.getLayout();
            layout.setConstraints(editableComponent, this.constraints);
            layout.layoutContainer(this.panelWithHelper);
        }
        if ("vectorDrawing".equals(((WComponent)this.getRenderer().getComponent()).getKey())) {
            ((Component)this.getRenderer().getRender()).dispatchEvent(new ComponentEvent((Component)this.getEditableComponent(), 101));
        }
    }

    private void refreshInternalConstraints() {
        WContainer parent = WidgetApiUtils.getComponentParent(this.getRenderer().getComponent(), this.getRenderer().getComponentContext().getWidget());
        if (parent == null) {
            return;
        }
        if (parent.getLayout() == 1) {
            WGridConstraints cs = null;
            if (parent.getChildren().contains(this.getRenderer().getComponent())) {
                cs = (WGridConstraints)parent.getChildConstraints((WComponent)this.getRenderer().getComponent());
            } else {
                Log.GUIBUILDER.debug((Object)("Unable to determine GridConstraints for " + ((WComponent)this.getRenderer().getComponent()).getName() + "; Default constraints will be used"));
                cs = (WGridConstraints)WidgetApiUtils.getComponentDefaultConstraints(parent, parent.getLayout());
            }
            this.constraints.anchor = cs.getAnchor();
            this.constraints.fill = cs.getFill();
            this.constraints.insets.bottom = cs.getInsetsBottom();
            this.constraints.insets.left = cs.getInsetsLeft();
            this.constraints.insets.right = cs.getInsetsRight();
            this.constraints.insets.top = cs.getInsetsTop();
        } else if (parent.getLayout() == 2) {
            this.constraints.insets.set(0, 0, 0, 0);
            this.constraints.anchor = 18;
        }
    }

    @Override
    public JPanel getProduction() {
        return this.panelWithHelper;
    }

    @Override
    public void resetRender() {
        this.recreateEditableComponent();
        this.initView();
        WContainerContext parent = this.getRenderer().getEngine().getViewer().getParentContext(this.getRenderer().getComponentContext());
        ((WidgetComponentRenderer)this.getRenderer().getEngine().getViewer().getComponentRenderer(parent)).getProduction();
    }

    public void resetWidth() {
        int newWidth = ((WComponent)this.getRenderer().getComponent()).getWidth() == 0 ? ((JComponent)this.getRenderer().getRender()).getPreferredSize().width : ((WAbstractComponent)this.getRenderer().getComponentContext().getComponent()).getWidth();
        Dimension d = ((JComponent)this.getRenderer().getRender()).getPreferredSize();
        d.width = newWidth;
        this.resizeEditableComponent(d);
        this.reinitConstraints();
    }

    public void resetHeight() {
        int newHeight;
        if (((WComponent)this.getRenderer().getComponent()).getHeight() == 0) {
            this.getRenderer().setRender(null);
            newHeight = ((JComponent)this.getRenderer().getRender()).getPreferredSize().height;
            this.initView();
        } else {
            newHeight = ((WComponent)this.getRenderer().getComponent()).getHeight();
        }
        Dimension d = ((JComponent)this.getRenderer().getRender()).getPreferredSize();
        d.height = newHeight;
        this.resizeEditableComponent(d);
        this.reinitConstraints();
    }

    private void resizeEditableComponent(Dimension d) {
        ((JComponent)this.getRenderer().getRender()).setPreferredSize(d);
        if (this.getGuiBuilder().getWorkPane().getSelectedNodes().contains(this.getRenderer().getComponentContext())) {
            this.getGuiBuilder().getWorkPane().repaint();
        }
    }

    public List<ExtendedBinding> getCreatedBindings(Reference ref, EntityNode en) throws SyntaxErrorException {
        LinkedList<ExtendedBinding> bs = new LinkedList<ExtendedBinding>();
        Reference elementRef = WBindingUtils.getReferenceForComponentProperty(this.getRenderer().getComponent(), this.getRenderer().getComponentContext().getDefaultPropertyName());
        if (ref.getEntityType() == 2) {
            this.addFunctionBindings(ref, en, bs, elementRef);
        } else if (ref.getEntityType() == 4) {
            EvaluationOptions eOpts = new EvaluationOptions(2);
            eOpts.setActivator(ref);
            bs.add(new ExtendedBinding(new Binding(elementRef, new Expression(ref)), eOpts));
        } else if (ref.getContext() != null) {
            EvaluationOptions eOpts;
            if (!en.isReadOnly()) {
                eOpts = new EvaluationOptions(2);
                eOpts.setActivator(WBindingUtils.getSubmitReference());
                bs.add(new ExtendedBinding(new Binding(ref, new Expression(elementRef)), eOpts));
            }
            eOpts = new EvaluationOptions(3);
            bs.add(new ExtendedBinding(new Binding(elementRef, new Expression(ref)), eOpts));
        }
        return bs;
    }

    private void addFunctionBindings(Reference ref, EntityNode en, List<ExtendedBinding> bs, Reference elementRef) throws SyntaxErrorException {
        if (ref.getField() == null) {
            Reference activator = new Reference();
            activator.setSchema("form");
            activator.setContext(elementRef.getContext());
            activator.setEntityType(4);
            activator.setEntity("mouseClicked");
            for (ExtendedBinding fbg : WBindingUtils.getFunctionBindings(ref, this.getGuiBuilder().getWidget().getBindings())) {
                EvaluationOptions eo = fbg.getEvaluationOptions().clone();
                eo.setActivator(activator);
                bs.add(new ExtendedBinding(fbg.getBinding(), eo));
            }
            Binding callBg = new Binding(ref, null);
            EvaluationOptions eo = new EvaluationOptions(false, true, 0L);
            eo.setActivator(activator);
            bs.add(new ExtendedBinding(callBg, eo));
        } else if (en != null && en.getEntityObject().isInputField()) {
            EvaluationOptions eOpts = new EvaluationOptions(2);
            this.inheritFunctionActivator(ref, eOpts);
            bs.add(new ExtendedBinding(new Binding(ref, new Expression(elementRef)), eOpts));
        } else if (en != null && !en.getEntityObject().isInputField()) {
            EvaluationOptions eOpts = new EvaluationOptions(2);
            this.inheritFunctionActivator(ref, eOpts);
            bs.add(new ExtendedBinding(new Binding(elementRef, new Expression(ref)), eOpts));
        }
    }

    private void inheritFunctionActivator(Reference ref, EvaluationOptions eOpts) throws SyntaxErrorException {
        List<ExtendedBinding> bgs = WBindingUtils.getFunctionBindings(ref, this.getGuiBuilder().getWidget().getBindings());
        if (bgs.size() == 0) {
            return;
        }
        ExtendedBinding fb = bgs.get(0);
        if (fb != null) {
            eOpts.setActivator(fb.getEvaluationOptions().getActivator());
        }
    }

    public CustomTransferHandler getCustomTransferHandler(DataFlavor flavor) {
        return null;
    }

    public void refreshParentWidth() {
        WContainerContext<WComponentContext, WContainer> parent = this.getGuiBuilder().getViewer().getParentContext(this.getRenderer().getComponentContext());
        if (parent != null && this.getGuiBuilder().getTemplateChangesManager() != null) {
            this.getGuiBuilder().getTemplateChangesManager().deferComponentSizeRevalidation((WComponent)parent.getComponent());
        }
    }

    @Override
    public void componentPropertyChanged(String prop) {
        if (WidgetConstants.CONSTRAINTS_PROPERTIES_LIST.contains(prop)) {
            this.reinitConstraints();
            this.getEditableComponent().refreshHandlers();
        } else if (prop.equals("width")) {
            this.resetWidth();
        } else if (prop.equals("height")) {
            this.resetHeight();
        } else if (prop.equals("border")) {
            ((JComponent)this.getRenderer().getRender()).setBorder(((WAbstractComponent)this.getRenderer().getComponent()).getBorder());
            if (this.getGuiBuilder().getViewer().isDecoratedMode()) {
                this.addEditorModeDecorations();
            }
            this.resetWidth();
            this.resetHeight();
            this.refreshParentWidth();
        } else if (prop.equals("font")) {
            if (((WAbstractComponent)this.getRenderer().getComponent()).getFont() != null) {
                ((JComponent)this.getRenderer().getRender()).setFont(((WAbstractComponent)this.getRenderer().getComponent()).getFont());
            }
            this.resetWidth();
            this.resetHeight();
            this.refreshParentWidth();
        } else if (prop.equals("cursor")) {
            if (((WAbstractComponent)this.getRenderer().getComponent()).getCursor() != null) {
                ((Component)this.getRenderer().getRender()).setCursor(Cursor.getPredefinedCursor(((WAbstractComponent)this.getRenderer().getComponent()).getCursor()));
                this.resetWidth();
            }
        } else if (prop.equals("popupMenu")) {
            WidgetComponentApiRendererUtilities.setComponentPopupMenu(this.getRenderer().getComponentContext(), (JComponent)this.getRenderer().getRender(), this.getRenderer().getEngine().getServerContextManager());
        } else if (prop.equals("visible")) {
            this.getEditableComponent().setVisible(((WAbstractComponent)this.getRenderer().getComponent()).isVisible());
        } else if (prop.equals("focusable")) {
            this.getEditableComponent().setFocusable(((WAbstractComponent)this.getRenderer().getComponent()).isFocusable());
        } else {
            try {
                AbstractSwingRenderer.synchronizeProperty(prop, this.getRenderer().getComponent(), this.getRenderer().getRender());
            }
            catch (ContextException ex) {
                Log.GUIBUILDER.warn((Object)ex.getMessage(), (Throwable)ex);
                return;
            }
        }
        if (this.getGuiBuilder().getWorkPane().getSelectedNodes().contains(this.getRenderer().getComponentContext())) {
            this.getGuiBuilder().getToolBar().buttonsEnabledForElements(this.getGuiBuilder().getWorkPane().getSelectedNodes());
        }
        this.renderChanged();
    }

    @Override
    public boolean isInteractive() {
        return false;
    }

    @Override
    public void stop() {
        super.stop();
        if (this.editableComponent != null) {
            this.editableComponent.stop();
        }
    }

    @Override
    public void renderChanged() {
        this.panelWithHelper.revalidate();
        this.editableComponent.refresh();
        this.getGuiBuilder().getWorkPane().repaint();
    }
}

