/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.client.guibuilder;

import com.tibbo.aggregate.client.guibuilder.AggreGateIDE;
import com.tibbo.aggregate.common.widget.Res;
import com.tibbo.aggregate.common.widget.component.WComponent;
import com.tibbo.aggregate.common.widget.engine.TemplateResource;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.TreeNode;

public class TemplateResourceNode
implements TreeNode {
    public static String BRACKETS_OPEN = " (";
    public static String BRACKETS_CLOSE = ")";
    private final TemplateResource resource;
    private TemplateResourceNode parent;
    final List<TemplateResourceNode> children = new LinkedList<TemplateResourceNode>();
    private final String key;
    private final AggreGateIDE guiBuilder;

    public TemplateResourceNode(AggreGateIDE guiBuilder, TemplateResourceNode parent, TemplateResource resource, String key) {
        this.resource = resource;
        this.parent = parent;
        this.key = key;
        this.guiBuilder = guiBuilder;
    }

    public String getComponentNameNote() {
        String name = "";
        name = this.key.equals("buttonGroups") ? Res.get().getString("gbButtonGroups") : this.guiBuilder.getWComponent(this.key).getDescription();
        if (name.length() == 0) {
            return "";
        }
        return BRACKETS_OPEN + name + BRACKETS_CLOSE;
    }

    public String toString() {
        return this.resource.getID() + this.getComponentNameNote();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(int pos, TemplateResourceNode newNode) {
        List<TemplateResourceNode> list = this.children;
        synchronized (list) {
            this.children.add(pos, newNode);
        }
        newNode.getResource().setParent(this.getResource());
        newNode.setParent(this);
        this.guiBuilder.getDataModel().addResource(newNode.getResource());
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        if (this.resource.getID().equals("buttonGroups")) {
            return true;
        }
        WComponent c = this.guiBuilder.getWComponent(this.key);
        return c != null && c.isContainer();
    }

    @Override
    public boolean isLeaf() {
        if (this.resource.getID().equals("buttonGroups")) {
            return false;
        }
        return !this.getAllowsChildren();
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void setParent(TemplateResourceNode parent) {
        this.parent = parent;
        this.resource.setParent(parent.getResource());
    }

    public TemplateResource getResource() {
        return this.resource;
    }

    public void setID(String ID) {
        if (!this.resource.getID().equals(ID)) {
            this.resource.setID(ID);
        }
    }

    public void removeChild(TemplateResourceNode childNode) {
        this.children.remove(childNode);
        this.guiBuilder.getDataModel().removeResource(childNode.getResource().getID());
    }

    public String getKey() {
        return this.key;
    }

    public List<TemplateResourceNode> getChildren() {
        return this.children;
    }
}

