﻿using com.tibbo.aggregate.common.datatable;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace AggreGateTests
{
    /// <summary>
    /// Summary description for DataRecordTests
    /// </summary>
    [TestClass]
    public class DataRecordTests
    {
        [TestMethod]
        public void TestFloatFieldToString()
        {
            var dr = new DataRecord( new TableFormat(FieldFormat.create("data", FieldFormat.FLOAT_FIELD)));
            dr.setValue(0, 1.1f);

            float f = 1.1f;
            Assert.AreEqual(f.ToString(), dr.dataAsString(false, false));
        }

        [TestMethod]
        public void TestDoubleFieldToString()
        {
            var dr = new DataRecord(new TableFormat(FieldFormat.create("data", FieldFormat.DOUBLE_FIELD)));
            dr.setValue(0, 123456789.123456789d);

            double d = 123456789.123457;
            Assert.AreEqual(d.ToString(), dr.dataAsString(false, false));
        }
    }
}