﻿using System;
using System.IO;
using System.Threading;

namespace com.tibbo.aggregate.common.util
{
    public class StreamWrapper
    {
        private readonly Stream stream;
        private readonly BufferedStream bs;

        public const int SOCKET_FLASH_TIME = 50;

        private Timer socketFlushTimer = null;

        public StreamWrapper(Stream stream, int bufferSize)
        {
            this.stream = stream;

            if (bufferSize > 0)
                bs = new BufferedStream(stream, bufferSize);
            else
                bs = null;
        }

        public System.IO.Stream GetReadStream()
        {
            return stream;
        }

        private System.IO.Stream GetWriteStream()
        {
            if (bs != null) return bs;
            return stream;
        }

        public void Write(byte[] byteBytter, int offset, int count)
        {
            GetWriteStream().Write(byteBytter, offset, count);

            if (socketFlushTimer == null)
                socketFlushTimer = new Timer(SocketFlushTimerCallback, null, SOCKET_FLASH_TIME, 0);
            else
                socketFlushTimer.Change(SOCKET_FLASH_TIME, 0);
        }

        public void Close()
        {
            if (bs != null) bs.Close();
            stream.Close();
        }

        public void Flush()
        {
            if (bs != null)
            {
                if (bs.CanWrite) bs.Flush();
            }
            else stream.Flush();
        }

        private void SocketFlushTimerCallback(object state)
        {
            try
            {
                lock (this)
                {
                    Flush();
                }
            }
            catch (Exception)
            {
                // We shouldn't throw any exception here because this code is called from a separate timer thread
                // and may cause application crash.
            }
        }
    }
}
