#define BOOST_TEST_DYN_LINK
#define BOOST_TEST_MODULE ContextTest
#include <boost/test/unit_test.hpp>
#include "context/ContextUtils.h"

BOOST_AUTO_TEST_SUITE (ContextTest)

BOOST_AUTO_TEST_CASE(testValidNames)
{
    BOOST_CHECK(!ContextUtils::isValidContextName("invalid name"));
    BOOST_CHECK(ContextUtils::isValidContextName(""));
}

BOOST_AUTO_TEST_CASE(testMatchesToMask)
{
    BOOST_CHECK(ContextUtils::matchesToMask("users.admin.deviceservers.c1", "users.admin.deviceservers.c1"));
    BOOST_CHECK(ContextUtils::matchesToMask("users.*.deviceservers.c1", "users.admin.deviceservers.c1"));
    BOOST_CHECK(ContextUtils::matchesToMask("users.*.deviceservers.*", "users.admin.deviceservers.c1"));
    BOOST_CHECK(!ContextUtils::matchesToMask("users.admin.deviceservers.c1", "users.admin.deviceservers.c1.devices.1"));
    BOOST_CHECK(!ContextUtils::matchesToMask("users.*.deviceservers.*", "usersxxx.admin.deviceservers.c1"));
    BOOST_CHECK(ContextUtils::matchesToMask("users.*.deviceservers.c1", "users.admin.deviceservers.c1.devices", true, false));
    BOOST_CHECK(!ContextUtils::matchesToMask("users.*.deviceservers.c1", "users.admin.deviceservers.c1.devices", false, false));
}

BOOST_AUTO_TEST_CASE(testWeakAndStrongListeners)
{

}

BOOST_AUTO_TEST_SUITE_END( )


