
#define BOOST_TEST_DYN_LINK
//#define BOOST_TEST_MODULE Communication
#include <boost/test/unit_test.hpp>
#include "protocol/RemoteServer.h"
#include "util/BlockingChannel.h"
#include <iostream>

BOOST_AUTO_TEST_SUITE (TcpCommunication)

BOOST_AUTO_TEST_CASE(testBlockingChanel)
{
    BlockingChannel* tcpChanel = new BlockingChannel(5000);
    tcpChanel->connect("127.0.0.1", RemoteServer::DEFAULT_PORT());

    std::vector<unsigned char> dst(9);
    dst[0] = 2;
    dst[1] = 77;
    dst[2] = 23;
    dst[3] = 49;
    dst[4] = 23;
    dst[5]    = 83;
    dst[6] = 23;
    dst[7] = 50;
    dst[8] = 13;
    int sentByte = tcpChanel->write(dst);
    std::cout << "Send byte: " << sentByte << "\n";

    int readByte = 0;
    boost::asio::streambuf answ;
    while (1) {
        readByte = tcpChanel->read(answ);
        if (!readByte)
            break;
        std::cout << "Read byte: " << readByte << "\n";
    }

    tcpChanel->close();
    delete tcpChanel;
}

BOOST_AUTO_TEST_SUITE_END( )
