#define BOOST_TEST_DYN_LINK
#define BOOST_TEST_MODULE Communication
#include <boost/test/unit_test.hpp>
#include "protocol/RemoteServer.h"
#include "protocol/RemoteServerController.h"
#include "datatable/DataTable.h"
#include "server/RootContextConstants.h"
#include "util/Pointers.h"
#include "util/Logger.h"

BOOST_AUTO_TEST_SUITE (Api)

BOOST_AUTO_TEST_CASE(testGetServerVersion)
{
    AGDEBUG_CONF("log.txt", Logger::file_on|Logger::screen_on, DBG_DEBUG, DBG_ERROR);

    try
    {
        // Provide correct server address/port and name/password of server user to log in as
        RemoteServerPtr rls = RemoteServerPtr( new RemoteServer("127.0.0.1", RemoteServer::DEFAULT_PORT(), "admin", "admin") );

        // Creating server controller
        // off async mode
        boost::shared_ptr<RemoteServerController> rlc = RemoteServerControllerPtr( new RemoteServerController(rls.get(), false) );

        // Connecting to the server
        rlc->connect();

        // Authentication/authorization
        rlc->login();

        // Getting context manager
        ContextManager* cm = rlc->getContextManager();

        // Getting root context
        Context* rootContext = cm->getRoot();

        // Getting "version" variable from the root context
        DataTablePtr versionData = rootContext->getVariable(RootContextConstants::V_VERSION);

        // Version string is contained in the first record and "version" field of the data table
        AgString serverVersion = versionData->rec()->getString(RootContextConstants::VF_VERSION_VERSION);

        std::cout << "Server version: " << serverVersion.toUtf8();

        // Disconnecting from the server
        rlc->disconnect();
    }
    catch (AggreGateException ex)
    {
        std::cout <<"Exception: " <<ex.getMessage().toUtf8();
    }
}

BOOST_AUTO_TEST_SUITE_END( )

