#include "util/simpleobject/AgInteger.h"
#include "util/simpleobject/AgString.h"
#include <boost/lexical_cast.hpp>

AgInteger::AgInteger(int val)
{
    value = val;
}

int AgInteger::getValue()
{
    return value;
}

int AgInteger::compareTo(Comparable *obj)
{
    AgInteger *other = static_cast<AgInteger *>(obj);
    if (value == other->value)
        return 0;
    else if (value < other->value)
        return -1;
    else
        return 1;
}

std::string AgInteger::getClass()
{
    return typeid(AgInteger).name();
}

int AgInteger::hashCode()
{
    return value;
}

bool AgInteger::equals(AgObject *obj)
{
    if (obj == NULL)
        return false;

    if (obj == this)
        return true;

    AgInteger *other = dynamic_cast<AgInteger *>(obj);
    if (!other)
    {
        return false;
    }

    return value == other->value;
}

AgString AgInteger::toString()
{
    AgString str = boost::lexical_cast<std::string>(value).c_str();
    return str;
}

Cloneable *AgInteger::clone()
{
    return new AgInteger(value);
}
