#include "util/simpleobject/AgFloat.h"
#include "util/simpleobject/AgString.h"
#include <boost/lexical_cast.hpp>
#include <string>

AgFloat::AgFloat(float val)
{
    value = val;
}

float AgFloat::getValue()
{
    return value;
}

int AgFloat::compareTo(Comparable *obj)
{
    AgFloat *other = static_cast<AgFloat *>(obj);
    if (fabs(value - other->value) < 0.000001)
        return 0;
    else if (value < other->value)
        return -1;
    else
        return 1;
}

std::string AgFloat::getClass()
{
    return typeid(AgFloat).name();
}

int AgFloat::hashCode()
{
    //not used
    assert(0);
    return 0;
}

bool AgFloat::equals(AgObject *obj)
{
    if (obj == NULL)
        return false;

    if (obj == this)
        return true;

    AgFloat *other = dynamic_cast<AgFloat *>(obj);
    if (!other)
    {
        return false;
    }

    return fabs(value - other->value) < 0.000001;
}

AgString AgFloat::toString()
{
    AgString str = AgString(boost::lexical_cast<std::string>(value).c_str());
    return str;
}

Cloneable *AgFloat::clone()
{
    return new AgFloat(value);
}
