#include "util/simpleobject/AgDouble.h"
#include "util/simpleobject/AgString.h"
#include <boost/lexical_cast.hpp>

AgDouble::AgDouble(double val)
{
    value = val;
}

double AgDouble::getValue()
{
    return value;
}

int AgDouble::compareTo(Comparable *obj)
{
    AgDouble *other = static_cast<AgDouble *>(obj);
    if (fabs(value - other->value) < 0.000001)
        return 0;
    else if (value < other->value)
        return -1;
    else
        return 1;
}

std::string AgDouble::getClass()
{
    return typeid(AgDouble).name();
}

int AgDouble::hashCode()
{
    //not used
    assert(0);
    return 0;
}

bool AgDouble::equals(AgObject *obj)
{
    if (obj == NULL)
        return false;

    if (obj == this)
        return true;

    AgDouble *other = dynamic_cast<AgDouble *>(obj);
    if (!other)
    {
        return false;
    }

    return fabs(value - other->value) < 0.000001;
}

AgString AgDouble::toString()
{
    AgString str = boost::lexical_cast<std::string>(value).c_str();
    return str;
}

Cloneable *AgDouble::clone()
{
    return new AgDouble(value);
}
