#pragma once

#include <string>
#include "util/AgObject.h"
#include "util/Comparable.h"
#include "util/Cloneable.h"
#include <boost/date_time/posix_time/posix_time.hpp>


// Represents a date and time
class AgDate : public AgObject, public Comparable, public Cloneable
{
public:

     AgDate();
     AgDate(int64_t millis);
     AgDate(boost::posix_time::ptime &t);

     boost::posix_time::ptime getValue();

     int compareTo(Comparable *obj);
     virtual std::string getClass();
     virtual int hashCode();
     virtual bool equals(AgObject* obj);
     virtual AgString toString();
     std::string toTimestampString();
     static AgDate currentDateTime();
     virtual Cloneable *clone();
     void setValue(boost::posix_time::ptime time);
     int64_t toTime();

private:
     boost::posix_time::ptime  time_;
};
