#pragma once
#include "util/AgObject.h"
#include "util/Comparable.h"
#include "util/Cloneable.h"

class AgColor : public AgObject, public Comparable, public Cloneable
{
public:  
    AgColor();
    AgColor(unsigned char r, unsigned char g, unsigned char b);
    AgColor(uint32_t value);

    unsigned char getRed() {
        return r;
    }

    unsigned char getGreen() {
        return g;
    }

    unsigned char getBlue() {
        return b;
    }

	uint32_t getAsInt()
	{
		return ((uint32_t)(((uint8_t)(r)|((uint16_t)((uint8_t)(g))<<8))|(((uint32_t)(uint8_t)(b))<<16)));
	}

    virtual int compareTo(Comparable *obj);
    virtual std::string getClass();
    virtual int hashCode();
    virtual bool equals(AgObject* obj);
    virtual AgString toString();
    virtual Cloneable *clone();

private:
    unsigned char r, g, b;
};

