#include "util/simpleobject/AgBoolean.h"
#include "util/simpleobject/AgString.h"

AgBoolean::AgBoolean(bool value)
{
    this->value = value;
}

bool AgBoolean::getValue()
{
    return value;
}

int AgBoolean::compareTo(Comparable *obj)
{
    AgBoolean *other = static_cast<AgBoolean *>(obj);
    if (value == other->value)
        return 0;
    else if (value < other->value)
        return -1;
    else
        return 1;
}

std::string AgBoolean::getClass()
{
    return typeid(AgBoolean).name();
}

int AgBoolean::hashCode()
{
    return value;
}

bool AgBoolean::equals(AgObject *obj)
{
    if (obj == NULL)
        return false;

    if (obj == this)
        return true;

    AgBoolean *other = dynamic_cast<AgBoolean *>(obj);
    if (!other)
    {
        return false;
    }

    return value == other->value;
}

AgString AgBoolean::toString()
{
    return value ? "true" : "false";
}

Cloneable *AgBoolean::clone()
{
    return new AgBoolean(value);
}


