#pragma once

#include <boost/shared_ptr.hpp>
#include <stdint.h>

#define SAFE_DELETE(punk) if ((punk) != NULL) { delete (punk); (punk) = NULL; }
#define UNUSED(expr) do { (void)(expr); } while (0)

class DataTable;
class FormatConverter;
class ClassicEncodingSettings;
class Data;
class AgObject;
class TableFormat;
class DataRecord;
class DataTableQuery;
class FieldFormat;
class Evaluator;
class Expression;
class DataTableSorter;
class TableKeyFieldsValidator;
class RecordValidator;
class TableValidator;
class LimitsValidator;
class Binding;
class Reference;
class QueryCondition;
class EvaluationEnvironment;
class FieldValidator;
class DataTableBindingProvider;
class DefaultBindingProcessor;
class AgString;
class FireChangeEventRequestController;
class ElementList;

typedef boost::shared_ptr<ElementList> ElementListPtr;
typedef boost::shared_ptr<AgObject> AgObjectPtr;
typedef boost::shared_ptr<TableFormat> TableFormatPtr;
typedef boost::shared_ptr<DataTable> DataTablePtr;
typedef boost::shared_ptr<FieldFormat> FieldFormatPtr;
typedef boost::shared_ptr<DataRecord> DataRecordPtr;
typedef boost::shared_ptr<FormatConverter> FormatConverterPtr;
typedef boost::shared_ptr<ClassicEncodingSettings> ClassicEncodingSettingsPtr;
typedef boost::shared_ptr<Data> DataPtr;
typedef boost::shared_ptr<Evaluator> EvaluatorPtr;
typedef boost::shared_ptr<Expression> ExpressionPtr;
typedef boost::shared_ptr<DataTableQuery> DataTableQueryPtr;
typedef boost::shared_ptr<DataTableSorter> DataTableSorterPtr;
typedef boost::shared_ptr<TableKeyFieldsValidator> TableKeyFieldsValidatorPtr;
typedef boost::shared_ptr<RecordValidator> RecordValidatorPtr;
typedef boost::shared_ptr<TableValidator> TableValidatorPtr;
typedef boost::shared_ptr<LimitsValidator> LimitsValidatorPtr;
typedef boost::shared_ptr<Binding> BindingPtr;
typedef boost::shared_ptr<Reference> ReferencePtr;
typedef boost::shared_ptr<QueryCondition> QueryConditionPtr;
typedef boost::shared_ptr<EvaluationEnvironment> EvaluationEnvironmentPtr;
typedef boost::shared_ptr<FieldValidator> FieldValidatorPtr;
typedef boost::shared_ptr<AgString> AgStringPtr;

typedef boost::shared_ptr<DataTableBindingProvider> DataTableBindingProviderPtr;
typedef boost::shared_ptr<DefaultBindingProcessor> DefaultBindingProcessorPtr;

typedef boost::shared_ptr<FireChangeEventRequestController> FireChangeEventRequestControllerPtr;

class CallerController;
class CallerData;
class Permission;
class Permissions;
class PermissionCache;
class AgDate;
class ContextManager;
class Context;
class VariableData;
class PermissionChecker;
class FunctionData;
class VariableDefinition;
class EventData;
class ActionDefinition;
class ContextStatus;
class ContextVisitor;
class NewContextVisitor;
class VariableStatus;
class RequestController;
class EventProcessingRule;
class ContextEventListener;
class Event;
class RequestIdentifier;
class ActionResponse;
class ActionCommand;
class GroupIdentifier;
class BatchEntry;
class Enrichment;
class ActionContext;
class FunctionDefinition;
class Acknowledgement;
class InitialRequest;
class EventDefinition;
class BatchContext;
class ActionManager;
class RequestCache;
class ActionIdentifier;
class ActionState;
class ActionResult;
class FireEventRequestController;
class ActionIdGenerator;
class Context;
class PersistenceBinding;
class PersistenceOptions;
class FunctionImplementation;
class GenericActionResponse;
class ActionInitializer;
class Expression;
class ServerActionInput;
class ActionExecutionMode;
class GenericActionCommand;
class ErrorCollector;
class WindowLocation;
class DashboardProperties;
class Action;
class ActionDirectory;
class VariableGetter;
class VariableSetter;
class EventEnrichmentRule;
class GenericActionResponse;
class GenericActionCommand;
class ActionLocator;
class ActionExecutionMode;
class ServerActionInput;
class ErrorCollector;
class ActionInitializer;
class ResourceMask;
class BasicActionDefinition;
class BatchAction;
class TreeMask;
class EntityReference;
class WindowLocation;
class DashboardProperties;
class ResourceBundle;
class Locale;
class OutgoingAggreGateCommand;
class ContextEventListenerInfo;
class CommandParser;
class IncomingAggreGateCommand;
class BlockingChannel;
class ContextEventListenerSet;
class PermissionType;
class RemoteServer;
class Agent;
class AgentContext;
class AgentContextManager;
class BindingProvider;
class CallerControllerSelector;
class ChangeCache;
class BindingProcessor;
class EvaluationOptions;
class ReferenceListener;
class AggreGateException;
class Command;
class CommandParserListener;
class AbstractDeviceController;
class CommandProcessorStatistics;
class AsyncCommandProcessor;
class PluginDirector;
class GroupContext;
class DeviceAssetDefinition;
class DeviceContext;
class SynchronizationParameters;
class SettingSynchronizationOptions;
class DeviceSettingStatus;
class SynchronizationHandler;
class Color;
class ReferenceWriter;
class SynchronizationResult;
class DiscoveryProvider;
class DeviceRecommendation;
class DiscoverableServiceDefinition;
class DiscoveryResultItem;
class DiscoverableService;
class ServerContext;
class BasePlugin;
class AggreGateDevice;
class UserSettings;
class FormatCache;
class RemoteContextManager;
class EntityRelatedActionDescriptor;
class AbstractAggreGateDeviceController;
class ProxyContext;
class EntityRelatedActionDescriptor;
class URI;
class EditDataMerger;
class DashboardProperties;
class EntityList;
class ExecutorService;
class EventDispatcher;
class CompatibilityConverter;
class ReferenceWriter;
class UncheckedCallerController;
class ExpressionParserVisitor;
class DefaultRequestController;
class ReferencesFinderVisitor;
class ExpressionParser;
class Comparable;
class KeyStroke;
class AgColor;
class ExtensionsPlugin;
class ReferenceResolver;
class DefaultReferenceResolver;
class ReplyMonitor;
class AggreReadableByteChannel;
class AggreGateCommandParser;
class AgentImplementationController;
class DefaultClientController;
class ThreadPoolCachedEx;
class QueuedEvent;
class RemoteServerController;
class AbstractContext;
class AgThreadPool;

typedef boost::shared_ptr<CallerController>  CallerControllerPtr;
typedef boost::shared_ptr<CallerData>  CallerDataPtr;
typedef boost::shared_ptr<Permission>  PermissionPtr;
typedef boost::shared_ptr<Permissions>  PermissionsPtr;
typedef boost::shared_ptr<PermissionCache>  PermissionCachePtr;
typedef boost::shared_ptr<AgDate>  AgDatePtr;
typedef boost::shared_ptr<Context> ContextPtr;
typedef boost::shared_ptr<VariableData> VariableDataPtr;
typedef boost::shared_ptr<PermissionChecker>  PermissionCheckerPtr;
typedef boost::shared_ptr<FunctionData> FunctionDataPtr;
typedef boost::shared_ptr<VariableDefinition> VariableDefinitionPtr;
typedef boost::shared_ptr<EventData> EventDataPtr;
typedef boost::shared_ptr<ActionDefinition> ActionDefinitionPtr;
typedef boost::shared_ptr<ContextStatus> ContextStatusPtr;
typedef boost::shared_ptr<ContextVisitor> ContextVisitorPtr;
typedef boost::shared_ptr<NewContextVisitor> NewContextVisitorPtr;
typedef boost::shared_ptr<VariableStatus> VariableStatusPtr;
typedef boost::shared_ptr<RequestController> RequestControllerPtr;
typedef boost::shared_ptr<EventProcessingRule> EventProcessingRulePtr;
typedef boost::shared_ptr<ContextEventListener> ContextEventListenerPtr;
typedef boost::shared_ptr<Event> EventPtr;
typedef boost::shared_ptr<RequestIdentifier> RequestIdentifierPtr;
typedef boost::shared_ptr<ActionResponse> ActionResponsePtr;
typedef boost::shared_ptr<ActionCommand> ActionCommandPtr;
typedef boost::shared_ptr<GroupIdentifier> GroupIdentifierPtr;
typedef boost::shared_ptr<BatchEntry> BatchEntryPtr;
typedef boost::shared_ptr<Enrichment> EnrichmentPtr;
typedef boost::shared_ptr<ActionContext> ActionContextPtr;
typedef boost::shared_ptr<FunctionDefinition> FunctionDefinitionPtr;
typedef boost::shared_ptr<Acknowledgement> AcknowledgementPtr;
typedef boost::shared_ptr<InitialRequest> InitialRequestPtr;
typedef boost::shared_ptr<EventDefinition> EventDefinitionPtr;
typedef boost::shared_ptr<BatchContext> BatchContextPtr;
typedef boost::shared_ptr<ActionManager> ActionManagerPtr;
typedef boost::shared_ptr<RequestCache> RequestCachePtr;
typedef boost::shared_ptr<ActionIdentifier> ActionIdentifierPtr;
typedef boost::shared_ptr<ActionState> ActionStatePtr;
typedef boost::shared_ptr<ActionResult> ActionResultPtr;
typedef boost::shared_ptr<FireEventRequestController> FireEventRequestControllerPtr;
typedef boost::shared_ptr<ActionIdGenerator> ActionIdGeneratorPtr;
typedef boost::shared_ptr<Context> ContextPtr;
typedef boost::shared_ptr<PersistenceBinding> PersistenceBindingPtr;
typedef boost::shared_ptr<PersistenceOptions> PersistenceOptionsPtr;
typedef boost::shared_ptr<FunctionImplementation> FunctionImplementationPtr;
typedef boost::shared_ptr<GenericActionResponse> GenericActionResponsePtr;
typedef boost::shared_ptr<ActionInitializer> ActionInitializerPtr;
typedef boost::shared_ptr<Expression> ExpressionPtr;
typedef boost::shared_ptr<ServerActionInput> ServerActionInputPtr;
typedef boost::shared_ptr<ActionExecutionMode> ActionExecutionModePtr;
typedef boost::shared_ptr<GenericActionCommand> GenericActionCommandPtr;
typedef boost::shared_ptr<ErrorCollector> ErrorCollectorPtr;
typedef boost::shared_ptr<WindowLocation> WindowLocationPtr;
typedef boost::shared_ptr<DashboardProperties> DashboardPropertiesPtr;
typedef boost::shared_ptr<Action> ActionPtr;
typedef boost::shared_ptr<ActionDirectory> ActionDirectoryPtr;
typedef boost::shared_ptr<VariableGetter> VariableGetterPtr;
typedef boost::shared_ptr<VariableSetter> VariableSetterPtr;
typedef boost::shared_ptr<EventEnrichmentRule> EventEnrichmentRulePtr;
typedef boost::shared_ptr<GenericActionResponse> GenericActionResponsePtr;
typedef boost::shared_ptr<GenericActionCommand> GenericActionCommandPtr;
typedef boost::shared_ptr<ActionLocator> ActionLocatorPtr;
typedef boost::shared_ptr<ActionExecutionMode> ActionExecutionModePtr;
typedef boost::shared_ptr<ServerActionInput> ServerActionInputPtr;
typedef boost::shared_ptr<ErrorCollector> ErrorCollectorPtr;
typedef boost::shared_ptr<ActionInitializer> ActionInitializerPtr;
typedef boost::shared_ptr<ResourceMask> ResourceMaskPtr;
typedef boost::shared_ptr<BasicActionDefinition> BasicActionDefinitionPtr;
typedef boost::shared_ptr<BatchAction> BatchActionPtr;
typedef boost::shared_ptr<TreeMask> TreeMaskPtr;
typedef boost::shared_ptr<EntityReference> EntityReferencePtr;
typedef boost::shared_ptr<WindowLocation> WindowLocationPtr;
typedef boost::shared_ptr<DashboardProperties> DashboardPropertiesPtr;
typedef boost::shared_ptr<ResourceBundle> ResourceBundlePtr;
typedef boost::shared_ptr<Locale> LocalePtr;
typedef boost::shared_ptr<OutgoingAggreGateCommand> OutgoingAggreGateCommandPtr;
typedef boost::shared_ptr<ContextEventListenerInfo> ContextEventListenerInfoPtr;
typedef boost::shared_ptr<CommandParser> CommandParserPtr;
typedef boost::shared_ptr<IncomingAggreGateCommand> IncomingAggreGateCommandPtr;
typedef boost::shared_ptr<BlockingChannel> BlockingChannelPtr;
typedef boost::shared_ptr<ContextEventListenerSet> ContextEventListenerSetPtr;
typedef boost::shared_ptr<PermissionType> PermissionTypePtr;
typedef boost::shared_ptr<RemoteServer> RemoteServerPtr;
typedef boost::shared_ptr<Agent> AgentPtr;
typedef boost::shared_ptr<ContextManager> ContextManagerPtr;
typedef boost::shared_ptr<AgentContextManager> AgentContextManagerPtr;
typedef boost::shared_ptr<BindingProvider> BindingProviderPtr;
typedef boost::shared_ptr<CallerControllerSelector> CallerControllerSelectorPtr;
typedef boost::shared_ptr<ChangeCache> ChangeCachePtr;
typedef boost::shared_ptr<BindingProcessor> BindingProcessorPtr;
typedef boost::shared_ptr<EvaluationOptions> EvaluationOptionsPtr;
typedef boost::shared_ptr<ReferenceListener> ReferenceListenerPtr;
typedef boost::shared_ptr<AggreGateException> AggreGateExceptionPtr;
typedef boost::shared_ptr<Command> CommandPtr;
typedef boost::shared_ptr<CommandParserListener> CommandParserListenerPtr;
typedef boost::shared_ptr<AbstractDeviceController> AbstractDeviceControllerPtr;
typedef boost::shared_ptr<CommandProcessorStatistics> CommandProcessorStatisticsPtr;
typedef boost::shared_ptr<AsyncCommandProcessor> AsyncCommandProcessorPtr;
typedef boost::shared_ptr<PluginDirector> PluginDirectorPtr;
typedef boost::shared_ptr<GroupContext> GroupContextPtr;
typedef boost::shared_ptr<DeviceAssetDefinition> DeviceAssetDefinitionPtr;
typedef boost::shared_ptr<DeviceContext> DeviceContextPtr;
typedef boost::shared_ptr<SynchronizationParameters> SynchronizationParametersPtr;
typedef boost::shared_ptr<SettingSynchronizationOptions> SettingSynchronizationOptionsPtr;
typedef boost::shared_ptr<DeviceSettingStatus> DeviceSettingStatusPtr;
typedef boost::shared_ptr<SynchronizationHandler> SynchronizationHandlerPtr;
typedef boost::shared_ptr<SynchronizationResult> SynchronizationResultPtr;
typedef boost::shared_ptr<DiscoveryProvider> DiscoveryProviderPtr;
typedef boost::shared_ptr<DeviceRecommendation> DeviceRecommendationPtr;
typedef boost::shared_ptr<DiscoverableServiceDefinition> DiscoverableServiceDefinitionPtr;
typedef boost::shared_ptr<DiscoveryResultItem> DiscoveryResultItemPtr;
typedef boost::shared_ptr<DiscoverableService> DiscoverableServicePtr;
typedef boost::shared_ptr<ServerContext> ServerContextPtr;
typedef boost::shared_ptr<BasePlugin> BasePluginPtr;
typedef boost::shared_ptr<AggreGateDevice> AggreGateDevicePtr;
typedef boost::shared_ptr<UserSettings> UserSettingsPtr;
typedef boost::shared_ptr<FormatCache> FormatCachePtr;
typedef boost::shared_ptr<RemoteContextManager> RemoteContextManagerPtr;
typedef boost::shared_ptr<EntityRelatedActionDescriptor> EntityRelatedActionDescriptorPtr;
typedef boost::shared_ptr<AbstractAggreGateDeviceController> AbstractAggreGateDeviceControllerPtr;
typedef boost::shared_ptr<ProxyContext> ProxyContextPtr;
typedef boost::shared_ptr<EntityRelatedActionDescriptor> EntityRelatedActionDescriptorPtr;
typedef boost::shared_ptr<URI> URI_Ptr;
typedef boost::shared_ptr<EditDataMerger> EditDataMergerPtr;
typedef boost::shared_ptr<DashboardProperties> DashboardPropertiesPtr;
typedef boost::shared_ptr<EntityList> EntityListPtr;
typedef boost::shared_ptr<EventDispatcher> EventDispatcherPtr;
typedef boost::shared_ptr<CompatibilityConverter> CompatibilityConverterPtr;
typedef boost::shared_ptr<Color> ColorPtr;
typedef boost::shared_ptr<ReferenceWriter> ReferenceWriterPtr;
typedef boost::shared_ptr<UncheckedCallerController> UncheckedCallerControllerPtr;
typedef boost::shared_ptr<ExpressionParserVisitor> ExpressionParserVisitorPtr;
typedef boost::shared_ptr<DefaultRequestController> DefaultRequestControllerPtr;
typedef boost::shared_ptr<ReferencesFinderVisitor> ReferencesFinderVisitorPtr;
typedef boost::shared_ptr<ExpressionParser> ExpressionParserPtr;
typedef boost::shared_ptr<Comparable> ComparablePtr;
typedef boost::shared_ptr<KeyStroke> KeyStrokePtr;
typedef boost::shared_ptr<AgColor> AgColorPtr;
typedef boost::shared_ptr<ExtensionsPlugin> ExtensionsPluginPtr;
typedef boost::shared_ptr<ReferenceResolver> ReferenceResolverPtr;
typedef boost::shared_ptr<DefaultReferenceResolver> DefaultReferenceResolverPtr;
typedef boost::shared_ptr<ReplyMonitor> ReplyMonitorPtr;
typedef boost::shared_ptr<AggreReadableByteChannel> AggreReadableByteChannelPtr;
typedef boost::shared_ptr<AggreGateCommandParser> AggreGateCommandParserPtr;
typedef boost::shared_ptr<AgentImplementationController> AgentImplementationControllerPtr;
typedef boost::shared_ptr<DefaultClientController> DefaultClientControllerPtr;
typedef boost::shared_ptr<ThreadPoolCachedEx> ThreadPoolCachedExPtr;
typedef boost::shared_ptr<QueuedEvent> QueuedEventPtr;
typedef boost::shared_ptr<RemoteServerController> RemoteServerControllerPtr;
typedef boost::shared_ptr<AbstractContext> AbstractContextPtr;
typedef boost::shared_ptr<AgThreadPool> AgThreadPoolPtr;
