#pragma once

#include <boost/regex.hpp>
#include <util/simpleobject/AgString.h>

class MessageFormat
{
private:
    static std::string format(const std::string& pattern, std::vector<std::string>& params)
    {
        std::string result(pattern);
        std::string param;
        boost::regex e("\\{([^\\{\\}]+)\\}");
        boost::smatch m;

        while (boost::regex_search(result, m, e)) {
            int pos = AgString(m[1].str().c_str()).toInt();
            try{
                param = params.at(pos);
                result.replace(m.position(), m.length(), param);
            }catch(std::out_of_range ex) {
            }
        }

        return result;
    }

public:
    MessageFormat() {}

    static AgString format(const AgString& pattern, const AgString& param1)
    {
        std::vector<std::string> params;
        params.push_back(param1.toUtf8());

        return format(pattern.toUtf8(), params).c_str();
    }

    static AgString format(const AgString& pattern, const AgString& param1, const AgString& param2)
    {
        std::vector<std::string> params;
        params.push_back(param1.toUtf8());
        params.push_back(param2.toUtf8());

        return format(pattern.toUtf8(), params).c_str();
    }

    static AgString format(const AgString& pattern, const AgString& param1, const AgString& param2, const AgString& param3)
    {
        std::vector<std::string> params;
        params.push_back(param1.toUtf8());
        params.push_back(param2.toUtf8());
        params.push_back(param3.toUtf8());

        return format(pattern.toUtf8(), params).c_str();
    }
};
