#pragma once

#include "util/Element.h"
#include <vector>

class ElementList
{
public:
    std::vector<Element *> elements;

	ElementList()
	{
		elements.reserve(50);
	}

	~ElementList()
	{
		for (std::vector<Element *>::iterator it = elements.begin(); it != elements.end(); ++it)
		{
			delete *it;
		}
	}


    Element* getElement(const AgString &name)
    {
        for (std::vector<Element*>::iterator it = elements.begin(); it != elements.end(); ++it)
        {
            if ( !(*it)->getName().empty() && ((*it)->getName() == name))
            {
                return *it;
			}
        }
        return NULL;
    }
};
