#include "util/CloneUtils.h"
#include "util/Cloneable.h"
#include "util/AgObject.h"

AgObjectPtr CloneUtils::genericClone(AgObjectPtr object)
{
    if (object.get() == NULL)
    {
        return AgObjectPtr();
    }

    Cloneable *c = dynamic_cast<Cloneable *>(object.get());
    if (c)
    {
        return AgObjectPtr(dynamic_cast<AgObject *>(c->clone()));
    }

    assert(0);
    return AgObjectPtr();
}
