#include <boost/lambda/bind.hpp>

#include "util/AgThread.h"
//#include "log.h"

AgThread::AgThread()
{
    th_ = boost::shared_ptr<boost::thread>();
}

AgThread::~AgThread()
{
    th_.reset();
    th_ = NULL;
}

void AgThread::start()
{    
    th_.reset(new boost::thread(boost::lambda::bind(&AgThread::run, this)));
}

void AgThread::waitForFinished()
{
    if (th_)
    {
        if (th_->joinable())
        {
            th_->join();
        }
    }
}
