#include "util/AgObject.h"
#include "util/simpleobject/AgString.h"
#include "util/simpleobject/AgInteger.h"
#include "util/simpleobject/AgColor.h"
#include "util/simpleobject/AgLong.h"
#include "util/simpleobject/AgFloat.h"
#include "util/simpleobject/AgDouble.h"
#include "util/simpleobject/AgBoolean.h"
#include <assert.h>
#include "IllegalArgumentException.h"

std::string AgObject::getClass()
{
    return typeid(*this).name();
}

int AgObject::hashCode()
{
    assert(0);
    return 0;
}

AgString AgObject::toString()
{
    assert(0);
    return "";
}

bool AgObject::equals(AgObject* /*obj*/)
{
    assert(0);
    return false;
}

int AgObject::toInteger()
{
    AgInteger *v = dynamic_cast<AgInteger *>(this);
    if (v)
    {
		return v->getValue();
    }
	AgColor *c = dynamic_cast<AgColor *>(this);
	if (c)
	{
		return c->getAsInt();
	}
	
	throw IllegalArgumentException("AgObject::toInteger");
}

int64_t AgObject::toLong()
{
    AgLong *v = dynamic_cast<AgLong *>(this);
    if (!v)
    {
        throw IllegalArgumentException("AgObject::toLong");
    }
    return v->getValue();
}

bool AgObject::toBoolean()
{
    AgBoolean *v = dynamic_cast<AgBoolean *>(this);
    if (!v)
    {
        throw IllegalArgumentException("AgObject::AgBoolean");
    }
    return v->getValue();

}

double AgObject::toDouble()
{
    AgDouble *v = dynamic_cast<AgDouble *>(this);
    if (!v)
    {
        throw IllegalArgumentException("AgObject::AgDouble");
    }
    return v->getValue();
}

float AgObject::toFloat()
{
    AgFloat *v = dynamic_cast<AgFloat *>(this);
    if (!v)
    {
        AgDouble *d = dynamic_cast<AgDouble *>(this);
        if (!d)
        {
            throw IllegalArgumentException("AgObject::AgFloat");
        }
        return (float)d->getValue();
    }
    return v->getValue();
}
