﻿#include "security/PermissionCache.h"
#include <boost/thread/lock_guard.hpp>

PermissionCache::PermissionCache()
{

}

AgString PermissionCache::getLevel(const AgString& context)
{
    boost::lock_guard<boost::mutex> lockguard(lock_);
    {
        std::map<AgString,AgString>::iterator it = effectiveLevels.find(context);
        if (it != effectiveLevels.end())
            return it->second;
        else
            return "";
    }
}

void PermissionCache::cacheLevel(const AgString& context, const AgString& level)
{
    boost::lock_guard<boost::mutex> lockguard(lock_);
    {
        effectiveLevels.insert(std::pair<AgString,AgString>(context, level) );
    }
}
