#pragma once

#include "util/Cloneable.h"
#include "security/PermissionChecker.h"
#include "util/simpleobject/AgString.h"
#include <boost/thread/mutex.hpp>

class Permission : public Cloneable
{

private:
    static const char PERMISSION_FIELDS_SEPARATOR = ':';
    boost::mutex permissionsLock;
    AgString context;
    AgString level;

public:
    Permission(const AgString& data, boost::shared_ptr<PermissionChecker> checker);
    Permission(const AgString& context, const AgString& level);

    AgString getContext();
    AgString getLevel();
    void setContext(const AgString& entity);
    void setLevel(const AgString& level);
    AgString encode();
    Permission* clone();

    bool equals(Permission* other);
    AgString toString();
};
