#include "security/NullPermissionChecker.h"
#include "security/DefaultPermissionChecker.h"

std::map<AgString, AgString> NullPermissionChecker::getPermissionLevels()
{
    return std::map<AgString, AgString>();
}

bool NullPermissionChecker::has(
    CallerControllerPtr /*caller*/,
    PermissionsPtr /*requiredPermissions*/,
    Context* /*accessedContext*/
){
    return true;
}

bool NullPermissionChecker::canSee(PermissionsPtr /*perms*/, const AgString& /*context*/, ContextManager* /*cm*/)
{
    return true;
}

AgString NullPermissionChecker::getLevel(PermissionsPtr /*perms*/, const AgString& /*context*/, ContextManager* /*cm*/)
{
    return DefaultPermissionChecker::NULL_PERMISSIONS();
}

bool NullPermissionChecker::isValid(const AgString& /*permissionLevel*/)
{
    return true;
}

AgString NullPermissionChecker::canActivate(
    PermissionsPtr /*has*/,
    PermissionsPtr /*need*/,
    ContextManager* /*cm*/
){
    return "";
}

NullPermissionChecker::NullPermissionChecker()
{

}
