#pragma once

#include "protocol/AbstractAggreGateDeviceController.h"
#include "protocol/RemoteContextManager.h"
#include "protocol/RemoteServer.h"
#include <string>

class RemoteServerController : public AbstractAggreGateDeviceController
{
private:
    BlockingChannelPtr dataChannel;

protected:
	bool connectImpl();
    AgString getConnectionErrorMessage();
    bool loginImpl();
	void disconnectImpl();
    void send(CommandPtr cmd);
    void setDataChannel(BlockingChannelPtr socketChannel);
    BlockingChannelPtr getDataChannel();    

public:
    void start();
	bool isConnected();
    AgString getAddress();    

    RemoteServerController(RemoteServer* device, bool async);
    RemoteServerController(RemoteServer* device, bool async, bool useContextManager);
};
